/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpcds.row.generator;

import io.trino.tpcds.BusinessKeyGenerator;
import io.trino.tpcds.Nulls;
import io.trino.tpcds.Session;
import io.trino.tpcds.Table;
import io.trino.tpcds.distribution.ShipModeDistributions;
import io.trino.tpcds.generator.ShipModeGeneratorColumn;
import io.trino.tpcds.random.RandomValueGenerator;
import io.trino.tpcds.row.ShipModeRow;
import io.trino.tpcds.row.generator.AbstractRowGenerator;
import io.trino.tpcds.row.generator.RowGenerator;
import io.trino.tpcds.row.generator.RowGeneratorResult;

public class ShipModeRowGenerator
extends AbstractRowGenerator {
    public ShipModeRowGenerator() {
        super(Table.SHIP_MODE);
    }

    @Override
    public RowGeneratorResult generateRowAndChildRows(long rowNumber, Session session, RowGenerator parentRowGenerator, RowGenerator childRowGenerator) {
        long nullBitMap = Nulls.createNullBitMap(Table.SHIP_MODE, this.getRandomNumberStream(ShipModeGeneratorColumn.SM_NULLS));
        long smShipModeSk = rowNumber;
        String smShipModeId = BusinessKeyGenerator.makeBusinessKey(rowNumber);
        long index = rowNumber;
        String smType = ShipModeDistributions.getShipModeTypeForIndexModSize(rowNumber);
        String smCode = ShipModeDistributions.getShipModeCodeForIndexModSize(index /= (long)ShipModeDistributions.SHIP_MODE_TYPE_DISTRIBUTION.getSize());
        String smCarrier = ShipModeDistributions.getShipModeCarrierAtIndex((int)rowNumber - 1);
        String smContract = RandomValueGenerator.generateRandomCharset("abcdefghijklmnopqrstuvxyzABCDEFGHIJKLMNOPQRSTUVXYZ0123456789", 1, 20, this.getRandomNumberStream(ShipModeGeneratorColumn.SM_CONTRACT));
        return new RowGeneratorResult(new ShipModeRow(nullBitMap, smShipModeSk, smShipModeId, smType, smCode, smCarrier, smContract));
    }
}

