/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpcds.row.generator;

import io.trino.tpcds.BusinessKeyGenerator;
import io.trino.tpcds.Nulls;
import io.trino.tpcds.Session;
import io.trino.tpcds.Table;
import io.trino.tpcds.generator.WarehouseGeneratorColumn;
import io.trino.tpcds.random.RandomValueGenerator;
import io.trino.tpcds.row.WarehouseRow;
import io.trino.tpcds.row.generator.AbstractRowGenerator;
import io.trino.tpcds.row.generator.RowGenerator;
import io.trino.tpcds.row.generator.RowGeneratorResult;
import io.trino.tpcds.type.Address;

public class WarehouseRowGenerator
extends AbstractRowGenerator {
    public WarehouseRowGenerator() {
        super(Table.WAREHOUSE);
    }

    @Override
    public RowGeneratorResult generateRowAndChildRows(long rowNumber, Session session, RowGenerator parentRowGenerator, RowGenerator childRowGenerator) {
        long nullBitMap = Nulls.createNullBitMap(Table.WAREHOUSE, this.getRandomNumberStream(WarehouseGeneratorColumn.W_NULLS));
        long wWarehouseSk = rowNumber;
        String wWarehouseId = BusinessKeyGenerator.makeBusinessKey(rowNumber);
        String wWarehouseName = RandomValueGenerator.generateRandomText(10, 20, this.getRandomNumberStream(WarehouseGeneratorColumn.W_WAREHOUSE_NAME));
        int wWarehouseSqFt = RandomValueGenerator.generateUniformRandomInt(50000, 1000000, this.getRandomNumberStream(WarehouseGeneratorColumn.W_WAREHOUSE_SQ_FT));
        Address wAddress = Address.makeAddressForColumn(Table.WAREHOUSE, this.getRandomNumberStream(WarehouseGeneratorColumn.W_WAREHOUSE_ADDRESS), session.getScaling());
        return new RowGeneratorResult(new WarehouseRow(nullBitMap, wWarehouseSk, wWarehouseId, wWarehouseName, wWarehouseSqFt, wAddress));
    }
}

