/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import io.trino.hadoop.$internal.com.google.common.annotations.VisibleForTesting;
import io.trino.hadoop.$internal.com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockType;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.OutOfLegacyGenerationStampsException;
import org.apache.hadoop.hdfs.server.blockmanagement.SequentialBlockGroupIdGenerator;
import org.apache.hadoop.hdfs.server.blockmanagement.SequentialBlockIdGenerator;
import org.apache.hadoop.hdfs.server.common.GenerationStamp;

public class BlockIdManager {
    private final GenerationStamp legacyGenerationStamp = new GenerationStamp();
    private final GenerationStamp generationStamp = new GenerationStamp();
    private long legacyGenerationStampLimit = 0L;
    private final SequentialBlockIdGenerator blockIdGenerator;
    private final SequentialBlockGroupIdGenerator blockGroupIdGenerator;

    public BlockIdManager(BlockManager blockManager) {
        this.blockIdGenerator = new SequentialBlockIdGenerator(blockManager);
        this.blockGroupIdGenerator = new SequentialBlockGroupIdGenerator(blockManager);
    }

    public long upgradeLegacyGenerationStamp() {
        Preconditions.checkState(this.generationStamp.getCurrentValue() == 1000L);
        this.generationStamp.skipTo(this.legacyGenerationStamp.getCurrentValue() + 0x10000000000L);
        this.legacyGenerationStampLimit = this.generationStamp.getCurrentValue();
        return this.generationStamp.getCurrentValue();
    }

    public void setLegacyGenerationStampLimit(long stamp) {
        Preconditions.checkState(this.legacyGenerationStampLimit == 0L);
        this.legacyGenerationStampLimit = stamp;
    }

    public long getGenerationStampAtblockIdSwitch() {
        return this.legacyGenerationStampLimit;
    }

    @VisibleForTesting
    SequentialBlockIdGenerator getBlockIdGenerator() {
        return this.blockIdGenerator;
    }

    public void setLastAllocatedContiguousBlockId(long blockId) {
        this.blockIdGenerator.skipTo(blockId);
    }

    public long getLastAllocatedContiguousBlockId() {
        return this.blockIdGenerator.getCurrentValue();
    }

    public void setLastAllocatedStripedBlockId(long blockId) {
        this.blockGroupIdGenerator.skipTo(blockId);
    }

    public long getLastAllocatedStripedBlockId() {
        return this.blockGroupIdGenerator.getCurrentValue();
    }

    public void setLegacyGenerationStamp(long stamp) {
        this.legacyGenerationStamp.setCurrentValue(stamp);
    }

    public long getLegacyGenerationStamp() {
        return this.legacyGenerationStamp.getCurrentValue();
    }

    public void setGenerationStamp(long stamp) {
        this.generationStamp.setCurrentValue(stamp);
    }

    public long getGenerationStamp() {
        return this.generationStamp.getCurrentValue();
    }

    long nextGenerationStamp(boolean legacyBlock) throws IOException {
        return legacyBlock ? this.getNextLegacyGenerationStamp() : this.getNextGenerationStamp();
    }

    @VisibleForTesting
    long getNextLegacyGenerationStamp() throws IOException {
        long legacyGenStamp = this.legacyGenerationStamp.nextValue();
        if (legacyGenStamp >= this.legacyGenerationStampLimit) {
            throw new OutOfLegacyGenerationStampsException();
        }
        return legacyGenStamp;
    }

    @VisibleForTesting
    long getNextGenerationStamp() {
        return this.generationStamp.nextValue();
    }

    public long getLegacyGenerationStampLimit() {
        return this.legacyGenerationStampLimit;
    }

    boolean isLegacyBlock(Block block) {
        return block.getGenerationStamp() < this.getLegacyGenerationStampLimit();
    }

    long nextBlockId(BlockType blockType) {
        switch (blockType) {
            case CONTIGUOUS: {
                return this.blockIdGenerator.nextValue();
            }
            case STRIPED: {
                return this.blockGroupIdGenerator.nextValue();
            }
        }
        throw new IllegalArgumentException("nextBlockId called with an unsupported BlockType");
    }

    boolean isGenStampInFuture(Block block) {
        if (this.isLegacyBlock(block)) {
            return block.getGenerationStamp() > this.getLegacyGenerationStamp();
        }
        return block.getGenerationStamp() > this.getGenerationStamp();
    }

    void clear() {
        this.legacyGenerationStamp.setCurrentValue(1000L);
        this.generationStamp.setCurrentValue(1000L);
        this.getBlockIdGenerator().setCurrentValue(0x40000000L);
        this.getBlockGroupIdGenerator().setCurrentValue(Long.MIN_VALUE);
        this.legacyGenerationStampLimit = 0L;
    }

    public boolean isStripedBlock(Block block) {
        return BlockIdManager.isStripedBlockID(block.getBlockId()) && !this.isLegacyBlock(block);
    }

    public static boolean isStripedBlockID(long id) {
        return BlockType.fromBlockId(id) == BlockType.STRIPED;
    }

    static long convertToStripedID(long id) {
        return id & 0xFFFFFFFFFFFFFFF0L;
    }

    public static byte getBlockIndex(Block reportedBlock) {
        return (byte)(reportedBlock.getBlockId() & 0xFL);
    }

    SequentialBlockGroupIdGenerator getBlockGroupIdGenerator() {
        return this.blockGroupIdGenerator;
    }
}

