/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.BlockMetadataHeader;
import org.apache.hadoop.hdfs.server.datanode.ChunkChecksum;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.FileIoProvider;
import org.apache.hadoop.hdfs.server.datanode.LocalReplica;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInPipeline;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.ReplicaOutputStreams;
import org.apache.hadoop.hdfs.server.protocol.ReplicaRecoveryInfo;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.DataChecksum;

public class LocalReplicaInPipeline
extends LocalReplica
implements ReplicaInPipeline {
    private long bytesAcked;
    private long bytesOnDisk;
    private byte[] lastChecksum;
    private AtomicReference<Thread> writer = new AtomicReference();
    private long bytesReserved;
    private final long originalBytesReserved;

    public LocalReplicaInPipeline(long blockId, long genStamp, FsVolumeSpi vol, File dir, long bytesToReserve) {
        this(blockId, 0L, genStamp, vol, dir, Thread.currentThread(), bytesToReserve);
    }

    LocalReplicaInPipeline(Block block, FsVolumeSpi vol, File dir, Thread writer) {
        this(block.getBlockId(), block.getNumBytes(), block.getGenerationStamp(), vol, dir, writer, 0L);
    }

    LocalReplicaInPipeline(long blockId, long len, long genStamp, FsVolumeSpi vol, File dir, Thread writer, long bytesToReserve) {
        super(blockId, len, genStamp, vol, dir);
        this.bytesAcked = len;
        this.bytesOnDisk = len;
        this.writer.set(writer);
        this.bytesReserved = bytesToReserve;
        this.originalBytesReserved = bytesToReserve;
    }

    public LocalReplicaInPipeline(LocalReplicaInPipeline from) {
        super(from);
        this.bytesAcked = from.getBytesAcked();
        this.bytesOnDisk = from.getBytesOnDisk();
        this.writer.set(from.writer.get());
        this.bytesReserved = from.bytesReserved;
        this.originalBytesReserved = from.originalBytesReserved;
    }

    @Override
    public long getVisibleLength() {
        return -1L;
    }

    @Override
    public HdfsServerConstants.ReplicaState getState() {
        return HdfsServerConstants.ReplicaState.TEMPORARY;
    }

    @Override
    public long getBytesAcked() {
        return this.bytesAcked;
    }

    @Override
    public void setBytesAcked(long bytesAcked) {
        long newBytesAcked = bytesAcked - this.bytesAcked;
        this.bytesAcked = bytesAcked;
        this.getVolume().releaseReservedSpace(newBytesAcked);
        this.bytesReserved -= newBytesAcked;
    }

    @Override
    public long getBytesOnDisk() {
        return this.bytesOnDisk;
    }

    @Override
    public long getBytesReserved() {
        return this.bytesReserved;
    }

    @Override
    public long getOriginalBytesReserved() {
        return this.originalBytesReserved;
    }

    @Override
    public void releaseAllBytesReserved() {
        this.getVolume().releaseReservedSpace(this.bytesReserved);
        this.getVolume().releaseLockedMemory(this.bytesReserved);
        this.bytesReserved = 0L;
    }

    @Override
    public synchronized void setLastChecksumAndDataLen(long dataLength, byte[] checksum) {
        this.bytesOnDisk = dataLength;
        this.lastChecksum = checksum;
    }

    @Override
    public synchronized ChunkChecksum getLastChecksumAndDataLen() {
        return new ChunkChecksum(this.getBytesOnDisk(), this.lastChecksum);
    }

    @Override
    public void setWriter(Thread writer) {
        this.writer.set(writer);
    }

    @Override
    public void interruptThread() {
        Thread thread = this.writer.get();
        if (thread != null && thread != Thread.currentThread() && thread.isAlive()) {
            thread.interrupt();
        }
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public boolean attemptToSetWriter(Thread prevWriter, Thread newWriter) {
        return this.writer.compareAndSet(prevWriter, newWriter);
    }

    /*
     * Exception decompiling
     */
    @Override
    public void stopWriter(long xceiverStopTimeout) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReplicaOutputStreams createStreams(boolean isCreate, DataChecksum requestedChecksum) throws IOException {
        DataChecksum checksum;
        File blockFile = this.getBlockFile();
        File metaFile = this.getMetaFile();
        if (DataNode.LOG.isDebugEnabled()) {
            DataNode.LOG.debug("writeTo blockfile is " + blockFile + " of size " + blockFile.length());
            DataNode.LOG.debug("writeTo metafile is " + metaFile + " of size " + metaFile.length());
        }
        long blockDiskSize = 0L;
        long crcDiskSize = 0L;
        RandomAccessFile metaRAF = this.getFileIoProvider().getRandomAccessFile(this.getVolume(), metaFile, "rw");
        if (!isCreate) {
            boolean checkedMeta = false;
            try {
                BlockMetadataHeader header = BlockMetadataHeader.readHeader(metaRAF);
                checksum = header.getChecksum();
                if (checksum.getBytesPerChecksum() != requestedChecksum.getBytesPerChecksum()) {
                    throw new IOException("Client requested checksum " + requestedChecksum + " when appending to an existing block with different chunk size: " + checksum);
                }
                int bytesPerChunk = checksum.getBytesPerChecksum();
                int checksumSize = checksum.getChecksumSize();
                blockDiskSize = this.bytesOnDisk;
                crcDiskSize = (long)BlockMetadataHeader.getHeaderSize() + (blockDiskSize + (long)bytesPerChunk - 1L) / (long)bytesPerChunk * (long)checksumSize;
                if (blockDiskSize > 0L && (blockDiskSize > blockFile.length() || crcDiskSize > metaFile.length())) {
                    throw new IOException("Corrupted block: " + this);
                }
                checkedMeta = true;
            }
            finally {
                if (!checkedMeta) {
                    IOUtils.closeStream(metaRAF);
                }
            }
        } else {
            checksum = requestedChecksum;
        }
        FileIoProvider fileIoProvider = this.getFileIoProvider();
        FileOutputStream blockOut = null;
        FileOutputStream crcOut = null;
        try {
            blockOut = fileIoProvider.getFileOutputStream(this.getVolume(), new RandomAccessFile(blockFile, "rw").getFD());
            crcOut = fileIoProvider.getFileOutputStream(this.getVolume(), metaRAF.getFD());
            if (!isCreate) {
                blockOut.getChannel().position(blockDiskSize);
                crcOut.getChannel().position(crcDiskSize);
            }
            return new ReplicaOutputStreams(blockOut, crcOut, checksum, this.getVolume(), fileIoProvider);
        }
        catch (IOException e) {
            IOUtils.closeStream(blockOut);
            IOUtils.closeStream(crcOut);
            IOUtils.closeStream(metaRAF);
            throw e;
        }
    }

    @Override
    public OutputStream createRestartMetaStream() throws IOException {
        File blockFile = this.getBlockFile();
        File restartMeta = new File(blockFile.getParent() + File.pathSeparator + "." + blockFile.getName() + ".restart");
        if (!this.getFileIoProvider().deleteWithExistsCheck(this.getVolume(), restartMeta)) {
            DataNode.LOG.warn("Failed to delete restart meta file: " + restartMeta.getPath());
        }
        return this.getFileIoProvider().getFileOutputStream(this.getVolume(), restartMeta);
    }

    @Override
    public String toString() {
        return super.toString() + "\n  bytesAcked=" + this.bytesAcked + "\n  bytesOnDisk=" + this.bytesOnDisk;
    }

    @Override
    public ReplicaInfo getOriginalReplica() {
        throw new UnsupportedOperationException("Replica of type " + (Object)((Object)this.getState()) + " does not support getOriginalReplica");
    }

    @Override
    public long getRecoveryID() {
        throw new UnsupportedOperationException("Replica of type " + (Object)((Object)this.getState()) + " does not support getRecoveryID");
    }

    @Override
    public void setRecoveryID(long recoveryId) {
        throw new UnsupportedOperationException("Replica of type " + (Object)((Object)this.getState()) + " does not support setRecoveryID");
    }

    @Override
    public ReplicaRecoveryInfo createInfo() {
        throw new UnsupportedOperationException("Replica of type " + (Object)((Object)this.getState()) + " does not support createInfo");
    }

    public void moveReplicaFrom(ReplicaInfo oldReplicaInfo, File newBlkFile) throws IOException {
        if (!(oldReplicaInfo instanceof LocalReplica)) {
            throw new IOException("The source replica with blk id " + oldReplicaInfo.getBlockId() + " should be derived from LocalReplica");
        }
        LocalReplica oldReplica = (LocalReplica)oldReplicaInfo;
        File oldBlockFile = oldReplica.getBlockFile();
        File oldmeta = oldReplica.getMetaFile();
        File newmeta = this.getMetaFile();
        FileIoProvider fileIoProvider = this.getFileIoProvider();
        try {
            fileIoProvider.rename(this.getVolume(), oldmeta, newmeta);
        }
        catch (IOException e) {
            throw new IOException("Block " + oldReplicaInfo + " reopen failed.  Unable to move meta file  " + oldmeta + " to rbw dir " + newmeta, e);
        }
        try {
            fileIoProvider.rename(this.getVolume(), oldBlockFile, newBlkFile);
        }
        catch (IOException e) {
            try {
                fileIoProvider.rename(this.getVolume(), newmeta, oldmeta);
            }
            catch (IOException ex) {
                LOG.warn("Cannot move meta file " + newmeta + "back to the finalized directory " + oldmeta, ex);
            }
            throw new IOException("Block " + oldReplicaInfo + " reopen failed.  Unable to move block file " + oldReplica.getBlockFile() + " to rbw dir " + newBlkFile, e);
        }
    }

    @Override
    public ReplicaInfo getReplicaInfo() {
        return this;
    }
}

