/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.diskbalancer.planner;

import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import org.apache.hadoop.hdfs.server.diskbalancer.datamodel.DiskBalancerDataNode;
import org.apache.hadoop.hdfs.server.diskbalancer.planner.GreedyPlanner;
import org.apache.hadoop.hdfs.server.diskbalancer.planner.Planner;

public final class PlannerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(PlannerFactory.class);
    public static final String GREEDY_PLANNER = "greedyPlanner";

    public static Planner getPlanner(String plannerName, DiskBalancerDataNode node, double threshold) {
        if (plannerName.equals(GREEDY_PLANNER)) {
            if (LOG.isDebugEnabled()) {
                String message = String.format("Creating a %s for Node : %s IP : %s ID : %s", GREEDY_PLANNER, node.getDataNodeName(), node.getDataNodeIP(), node.getDataNodeUUID());
                LOG.debug(message);
            }
            return new GreedyPlanner(threshold, node);
        }
        throw new IllegalArgumentException("Unrecognized planner name : " + plannerName);
    }

    private PlannerFactory() {
    }
}

