/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import io.trino.hadoop.;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.security.CodeSource;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public final class FindClass
extends Configured
implements Tool {
    public static final String A_CREATE = "create";
    public static final String A_LOAD = "load";
    public static final String A_RESOURCE = "locate";
    public static final String A_PRINTRESOURCE = "print";
    public static final int SUCCESS = 0;
    protected static final int E_GENERIC = 1;
    protected static final int E_USAGE = 2;
    protected static final int E_NOT_FOUND = 3;
    protected static final int E_LOAD_FAILED = 4;
    protected static final int E_CREATE_FAILED = 5;
    private static PrintStream stdout = System.out;
    private static PrintStream stderr = System.err;

    public FindClass() {
        super(new Configuration());
    }

    public FindClass(Configuration conf) {
        super(conf);
    }

    @.VisibleForTesting
    public static void setOutputStreams(PrintStream out, PrintStream err) {
        stdout = out;
        stderr = err;
    }

    private Class getClass(String name) throws ClassNotFoundException {
        return this.getConf().getClassByName(name);
    }

    private URL getResource(String name) {
        return this.getConf().getResource(name);
    }

    private int loadResource(String name) {
        URL url = this.getResource(name);
        if (url == null) {
            FindClass.err("Resource not found: %s", name);
            return 3;
        }
        FindClass.out("%s: %s", name, url);
        return 0;
    }

    private int dumpResource(String name) {
        URL url = this.getResource(name);
        if (url == null) {
            FindClass.err("Resource not found:" + name, new Object[0]);
            return 3;
        }
        try {
            int data;
            InputStream instream = url.openStream();
            while (-1 != (data = instream.read())) {
                stdout.print((char)data);
            }
            stdout.print('\n');
            return 0;
        }
        catch (IOException e) {
            FindClass.printStack(e, "Failed to read resource %s at URL %s", name, url);
            return 4;
        }
    }

    private static void err(String s, Object ... args) {
        stderr.format(s, args);
        stderr.print('\n');
    }

    private static void out(String s, Object ... args) {
        stdout.format(s, args);
        stdout.print('\n');
    }

    private static void printStack(Throwable e, String text, Object ... args) {
        FindClass.err(text, args);
        e.printStackTrace(stderr);
    }

    private int loadClass(String name) {
        try {
            Class clazz = this.getClass(name);
            this.loadedClass(name, clazz);
            return 0;
        }
        catch (ClassNotFoundException e) {
            FindClass.printStack(e, "Class not found " + name, new Object[0]);
            return 3;
        }
        catch (Exception e) {
            FindClass.printStack(e, "Exception while loading class " + name, new Object[0]);
            return 4;
        }
        catch (Error e) {
            FindClass.printStack(e, "Error while loading class " + name, new Object[0]);
            return 4;
        }
    }

    private void loadedClass(String name, Class clazz) {
        FindClass.out("Loaded %s as %s", name, clazz);
        CodeSource source = clazz.getProtectionDomain().getCodeSource();
        URL url = source.getLocation();
        FindClass.out("%s: %s", name, url);
    }

    private int createClassInstance(String name) {
        try {
            Class clazz = this.getClass(name);
            this.loadedClass(name, clazz);
            Object instance = clazz.newInstance();
            try {
                FindClass.out("Created instance " + instance.toString(), new Object[0]);
            }
            catch (Exception e) {
                FindClass.printStack(e, "Created class instance but the toString() operator failed", new Object[0]);
            }
            return 0;
        }
        catch (ClassNotFoundException e) {
            FindClass.printStack(e, "Class not found " + name, new Object[0]);
            return 3;
        }
        catch (Exception e) {
            FindClass.printStack(e, "Exception while creating class " + name, new Object[0]);
            return 5;
        }
        catch (Error e) {
            FindClass.printStack(e, "Exception while creating class " + name, new Object[0]);
            return 5;
        }
    }

    @Override
    public int run(String[] args) throws Exception {
        int result;
        if (args.length != 2) {
            return this.usage(args);
        }
        String action = args[0];
        String name = args[1];
        if (A_LOAD.equals(action)) {
            result = this.loadClass(name);
        } else if (A_CREATE.equals(action)) {
            result = this.loadClass(name);
            if (result == 0) {
                result = this.createClassInstance(name);
            }
        } else {
            result = A_RESOURCE.equals(action) ? this.loadResource(name) : (A_PRINTRESOURCE.equals(action) ? this.dumpResource(name) : this.usage(args));
        }
        return result;
    }

    private int usage(String[] args) {
        FindClass.err("Usage : [load | create] <classname>", new Object[0]);
        FindClass.err("        [locate | print] <resourcename>]", new Object[0]);
        FindClass.err("The return codes are:", new Object[0]);
        this.explainResult(0, "The operation was successful");
        this.explainResult(1, "Something went wrong");
        this.explainResult(2, "This usage message was printed");
        this.explainResult(3, "The class or resource was not found");
        this.explainResult(4, "The class was found but could not be loaded");
        this.explainResult(5, "The class was loaded, but an instance of it could not be created");
        return 2;
    }

    private void explainResult(int errorcode, String text) {
        FindClass.err(" %2d -- %s ", errorcode, text);
    }

    public static void main(String[] args) {
        try {
            int result = ToolRunner.run(new FindClass(), args);
            System.exit(result);
        }
        catch (Exception e) {
            FindClass.printStack(e, "Running FindClass", new Object[0]);
            System.exit(1);
        }
    }
}

