/*
 * Decompiled with CFR 0.152.
 */
package alluxio.collections;

import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import java.util.ArrayList;
import java.util.List;

@NotThreadSafe
public class DirectedAcyclicGraphNode<T> {
    private final T mPayload;
    private final List<DirectedAcyclicGraphNode<T>> mParents;
    private final List<DirectedAcyclicGraphNode<T>> mChildren;

    public DirectedAcyclicGraphNode(T payload, List<DirectedAcyclicGraphNode<T>> parents, List<DirectedAcyclicGraphNode<T>> children) {
        this.mPayload = Preconditions.checkNotNull(payload, "payload");
        this.mParents = Preconditions.checkNotNull(parents, "parents");
        this.mChildren = Preconditions.checkNotNull(children, "children");
    }

    public DirectedAcyclicGraphNode(T payload) {
        this(payload, new ArrayList<DirectedAcyclicGraphNode<T>>(), new ArrayList<DirectedAcyclicGraphNode<T>>());
    }

    public T getPayload() {
        return this.mPayload;
    }

    public List<DirectedAcyclicGraphNode<T>> getParents() {
        return this.mParents;
    }

    public List<DirectedAcyclicGraphNode<T>> getChildren() {
        return this.mChildren;
    }

    public void addParent(DirectedAcyclicGraphNode<T> parent) {
        this.mParents.add(parent);
    }

    public void addChild(DirectedAcyclicGraphNode<T> child) {
        this.mChildren.add(child);
    }

    public void removeChild(DirectedAcyclicGraphNode<T> child) {
        Preconditions.checkState(this.mChildren.contains(child));
        this.mChildren.remove(child);
    }
}

