/*
 * Decompiled with CFR 0.152.
 */
package alluxio.grpc;

import alluxio.annotation.SuppressFBWarnings;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.grpc.GrpcServer;
import alluxio.grpc.GrpcServerAddress;
import alluxio.grpc.GrpcService;
import alluxio.grpc.ServiceType;
import alluxio.grpc.ServiceVersionClientServiceHandler;
import alluxio.security.authentication.AuthenticatedUserInjector;
import alluxio.security.authentication.AuthenticationServer;
import alluxio.security.authentication.DefaultAuthenticationServer;
import alluxio.security.user.UserState;
import alluxio.shaded.client.com.google.common.io.Closer;
import alluxio.shaded.client.io.grpc.ServerInterceptor;
import alluxio.shaded.client.io.grpc.ServerInterceptors;
import alluxio.shaded.client.io.grpc.ServerServiceDefinition;
import alluxio.shaded.client.io.grpc.netty.NettyServerBuilder;
import alluxio.shaded.client.io.netty.channel.ChannelOption;
import alluxio.shaded.client.io.netty.channel.EventLoopGroup;
import alluxio.shaded.client.io.netty.channel.ServerChannel;
import alluxio.shaded.client.io.netty.handler.ssl.SslContext;
import alluxio.shaded.client.javax.annotation.Nullable;
import alluxio.util.SecurityUtils;
import alluxio.util.network.tls.SslContextProvider;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public final class GrpcServerBuilder {
    private NettyServerBuilder mNettyServerBuilder;
    private Set<ServiceType> mServices;
    private AuthenticationServer mAuthenticationServer;
    private Closer mCloser = Closer.create();
    private AlluxioConfiguration mConfiguration;
    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    private UserState mUserState;

    private GrpcServerBuilder(GrpcServerAddress serverAddress, AuthenticationServer authenticationServer, AlluxioConfiguration conf, UserState userState) {
        this.mAuthenticationServer = authenticationServer;
        this.mNettyServerBuilder = NettyServerBuilder.forAddress(serverAddress.getSocketAddress());
        this.mServices = new HashSet<ServiceType>();
        this.mConfiguration = conf;
        this.mUserState = userState;
        if (conf.getBoolean(PropertyKey.NETWORK_TLS_ENABLED)) {
            this.sslContext(SslContextProvider.Factory.create(this.mConfiguration).getServerSSLContext());
        }
        if (SecurityUtils.isAuthenticationEnabled(this.mConfiguration)) {
            if (this.mAuthenticationServer == null) {
                this.mAuthenticationServer = new DefaultAuthenticationServer(serverAddress.getHostName(), this.mConfiguration);
            }
            this.addService(new GrpcService(this.mAuthenticationServer).disableAuthentication().withCloseable(this.mAuthenticationServer));
        }
    }

    public static GrpcServerBuilder forAddress(GrpcServerAddress serverAddress, AlluxioConfiguration conf, UserState userState) {
        return new GrpcServerBuilder(serverAddress, null, conf, userState);
    }

    public static GrpcServerBuilder forAddress(GrpcServerAddress serverAddress, AuthenticationServer authenticationServer, AlluxioConfiguration conf, UserState userState) {
        return new GrpcServerBuilder(serverAddress, authenticationServer, conf, userState);
    }

    public GrpcServerBuilder executor(@Nullable Executor executor) {
        this.mNettyServerBuilder = (NettyServerBuilder)this.mNettyServerBuilder.executor(executor);
        return this;
    }

    public GrpcServerBuilder flowControlWindow(int flowControlWindow) {
        this.mNettyServerBuilder = this.mNettyServerBuilder.flowControlWindow(flowControlWindow);
        return this;
    }

    public GrpcServerBuilder keepAliveTime(long keepAliveTime, TimeUnit timeUnit) {
        this.mNettyServerBuilder = this.mNettyServerBuilder.keepAliveTime(keepAliveTime, timeUnit);
        return this;
    }

    public GrpcServerBuilder keepAliveTimeout(long keepAliveTimeout, TimeUnit timeUnit) {
        this.mNettyServerBuilder = this.mNettyServerBuilder.keepAliveTimeout(keepAliveTimeout, timeUnit);
        return this;
    }

    public GrpcServerBuilder channelType(Class<? extends ServerChannel> channelType) {
        this.mNettyServerBuilder = this.mNettyServerBuilder.channelType(channelType);
        return this;
    }

    public <T> GrpcServerBuilder withChildOption(ChannelOption<T> option, T value) {
        this.mNettyServerBuilder = this.mNettyServerBuilder.withChildOption(option, value);
        return this;
    }

    public GrpcServerBuilder bossEventLoopGroup(EventLoopGroup bossGroup) {
        this.mNettyServerBuilder = this.mNettyServerBuilder.bossEventLoopGroup(bossGroup);
        return this;
    }

    public GrpcServerBuilder workerEventLoopGroup(EventLoopGroup workerGroup) {
        this.mNettyServerBuilder = this.mNettyServerBuilder.workerEventLoopGroup(workerGroup);
        return this;
    }

    public GrpcServerBuilder maxInboundMessageSize(int messageSize) {
        this.mNettyServerBuilder = this.mNettyServerBuilder.maxInboundMessageSize(messageSize);
        return this;
    }

    public GrpcServerBuilder addService(ServiceType serviceType, GrpcService serviceDefinition) {
        this.mServices.add(serviceType);
        return this.addService(serviceDefinition);
    }

    public GrpcServerBuilder addService(GrpcService serviceDefinition) {
        ServerServiceDefinition service = serviceDefinition.getServiceDefinition();
        if (SecurityUtils.isAuthenticationEnabled(this.mConfiguration) && serviceDefinition.isAuthenticated()) {
            service = ServerInterceptors.intercept(service, new AuthenticatedUserInjector(this.mAuthenticationServer));
        }
        this.mNettyServerBuilder = (NettyServerBuilder)this.mNettyServerBuilder.addService(service);
        this.mCloser.register(serviceDefinition.getCloser());
        return this;
    }

    public GrpcServerBuilder intercept(ServerInterceptor interceptor) {
        this.mNettyServerBuilder = (NettyServerBuilder)this.mNettyServerBuilder.intercept(interceptor);
        return this;
    }

    public GrpcServerBuilder sslContext(SslContext sslContext) {
        this.mNettyServerBuilder = this.mNettyServerBuilder.sslContext(sslContext);
        return this;
    }

    public GrpcServer build() {
        this.addService(new GrpcService(new ServiceVersionClientServiceHandler(this.mServices)).disableAuthentication());
        return new GrpcServer(this.mNettyServerBuilder.build(), this.mAuthenticationServer, this.mCloser, this.mConfiguration.getMs(PropertyKey.NETWORK_CONNECTION_SERVER_SHUTDOWN_TIMEOUT));
    }
}

