/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.netty.channel.sctp;

import alluxio.shaded.client.com.sun.nio.sctp.AbstractNotificationHandler;
import alluxio.shaded.client.com.sun.nio.sctp.AssociationChangeNotification;
import alluxio.shaded.client.com.sun.nio.sctp.HandlerResult;
import alluxio.shaded.client.com.sun.nio.sctp.Notification;
import alluxio.shaded.client.com.sun.nio.sctp.PeerAddressChangeNotification;
import alluxio.shaded.client.com.sun.nio.sctp.SendFailedNotification;
import alluxio.shaded.client.com.sun.nio.sctp.ShutdownNotification;
import alluxio.shaded.client.io.netty.channel.sctp.SctpChannel;
import alluxio.shaded.client.io.netty.util.internal.ObjectUtil;

public final class SctpNotificationHandler
extends AbstractNotificationHandler<Object> {
    private final SctpChannel sctpChannel;

    public SctpNotificationHandler(SctpChannel sctpChannel) {
        this.sctpChannel = ObjectUtil.checkNotNull(sctpChannel, "sctpChannel");
    }

    public HandlerResult handleNotification(AssociationChangeNotification notification, Object o) {
        this.fireEvent((Notification)notification);
        return HandlerResult.CONTINUE;
    }

    public HandlerResult handleNotification(PeerAddressChangeNotification notification, Object o) {
        this.fireEvent((Notification)notification);
        return HandlerResult.CONTINUE;
    }

    public HandlerResult handleNotification(SendFailedNotification notification, Object o) {
        this.fireEvent((Notification)notification);
        return HandlerResult.CONTINUE;
    }

    public HandlerResult handleNotification(ShutdownNotification notification, Object o) {
        this.fireEvent((Notification)notification);
        this.sctpChannel.close();
        return HandlerResult.RETURN;
    }

    private void fireEvent(Notification notification) {
        this.sctpChannel.pipeline().fireUserEventTriggered(notification);
    }
}

