/*
 * Decompiled with CFR 0.152.
 */
package alluxio.wire;

import alluxio.conf.Source;
import alluxio.grpc.ConfigProperty;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.javax.annotation.Nullable;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class Property {
    private final String mName;
    private final String mValue;
    private final String mSource;

    public Property(String name, @Nullable String value, Source source) {
        Preconditions.checkNotNull(name, "name");
        Preconditions.checkNotNull(source, "source");
        this.mName = name;
        this.mValue = value;
        this.mSource = source.toString();
    }

    private Property(ConfigProperty property) {
        this.mName = property.getName();
        this.mValue = property.getValue();
        this.mSource = property.getSource();
    }

    public static Property fromProto(ConfigProperty property) {
        return new Property(property);
    }

    public ConfigProperty toProto() {
        ConfigProperty.Builder builder = ConfigProperty.newBuilder();
        builder.setName(this.mName);
        if (this.mValue != null) {
            builder.setValue(this.mValue);
        }
        builder.setSource(this.mSource);
        return builder.build();
    }

    public String getName() {
        return this.mName;
    }

    public String getValue() {
        return this.mValue;
    }

    public String getSource() {
        return this.mSource;
    }
}

