/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.common;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.core.plan.DocIdSetPlanNode;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.datasource.DataSourceMetadata;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReaderContext;
import org.apache.pinot.spi.utils.BytesUtils;

public class DataFetcher {
    private static final ThreadLocal<int[]> THREAD_LOCAL_DICT_IDS = ThreadLocal.withInitial(() -> new int[DocIdSetPlanNode.MAX_DOC_PER_CALL]);
    private final Map<String, ColumnValueReader> _columnValueReaderMap = new HashMap<String, ColumnValueReader>();
    private final int[] _reusableMVDictIds;

    public DataFetcher(Map<String, DataSource> dataSourceMap) {
        int maxNumValuesPerMVEntry = 0;
        for (Map.Entry<String, DataSource> entry : dataSourceMap.entrySet()) {
            String column = entry.getKey();
            DataSource dataSource = entry.getValue();
            ColumnValueReader columnValueReader = new ColumnValueReader(dataSource.getForwardIndex(), dataSource.getDictionary());
            this._columnValueReaderMap.put(column, columnValueReader);
            DataSourceMetadata dataSourceMetadata = dataSource.getDataSourceMetadata();
            if (dataSourceMetadata.isSingleValue()) continue;
            maxNumValuesPerMVEntry = Math.max(maxNumValuesPerMVEntry, dataSourceMetadata.getMaxNumValuesPerMVEntry());
        }
        this._reusableMVDictIds = new int[maxNumValuesPerMVEntry];
    }

    public void fetchDictIds(String column, int[] inDocIds, int length, int[] outDictIds) {
        this._columnValueReaderMap.get(column).readDictIds(inDocIds, length, outDictIds);
    }

    public void fetchIntValues(String column, int[] inDocIds, int length, int[] outValues) {
        this._columnValueReaderMap.get(column).readIntValues(inDocIds, length, outValues);
    }

    public void fetchLongValues(String column, int[] inDocIds, int length, long[] outValues) {
        this._columnValueReaderMap.get(column).readLongValues(inDocIds, length, outValues);
    }

    public void fetchFloatValues(String column, int[] inDocIds, int length, float[] outValues) {
        this._columnValueReaderMap.get(column).readFloatValues(inDocIds, length, outValues);
    }

    public void fetchDoubleValues(String column, int[] inDocIds, int length, double[] outValues) {
        this._columnValueReaderMap.get(column).readDoubleValues(inDocIds, length, outValues);
    }

    public void fetchStringValues(String column, int[] inDocIds, int length, String[] outValues) {
        this._columnValueReaderMap.get(column).readStringValues(inDocIds, length, outValues);
    }

    public void fetchBytesValues(String column, int[] inDocIds, int length, byte[][] outValues) {
        this._columnValueReaderMap.get(column).readBytesValues(inDocIds, length, outValues);
    }

    public void fetchDictIds(String column, int[] inDocIds, int length, int[][] outDictIds) {
        this._columnValueReaderMap.get(column).readDictIdsMV(inDocIds, length, outDictIds);
    }

    public void fetchIntValues(String column, int[] inDocIds, int length, int[][] outValues) {
        this._columnValueReaderMap.get(column).readIntValuesMV(inDocIds, length, outValues);
    }

    public void fetchLongValues(String column, int[] inDocIds, int length, long[][] outValues) {
        this._columnValueReaderMap.get(column).readLongValuesMV(inDocIds, length, outValues);
    }

    public void fetchFloatValues(String column, int[] inDocIds, int length, float[][] outValues) {
        this._columnValueReaderMap.get(column).readFloatValuesMV(inDocIds, length, outValues);
    }

    public void fetchDoubleValues(String column, int[] inDocIds, int length, double[][] outValues) {
        this._columnValueReaderMap.get(column).readDoubleValuesMV(inDocIds, length, outValues);
    }

    public void fetchStringValues(String column, int[] inDocIds, int length, String[][] outValues) {
        this._columnValueReaderMap.get(column).readStringValuesMV(inDocIds, length, outValues);
    }

    public void fetchNumValues(String column, int[] inDocIds, int length, int[] outNumValues) {
        this._columnValueReaderMap.get(column).readNumValuesMV(inDocIds, length, outNumValues);
    }

    private class ColumnValueReader
    implements Closeable {
        final ForwardIndexReader _reader;
        final Dictionary _dictionary;
        boolean _readerContextCreated;
        ForwardIndexReaderContext _readerContext;

        ColumnValueReader(@Nullable ForwardIndexReader reader, Dictionary dictionary) {
            this._reader = reader;
            this._dictionary = dictionary;
        }

        private ForwardIndexReaderContext getReaderContext() {
            if (!this._readerContextCreated) {
                this._readerContext = this._reader.createContext();
                this._readerContextCreated = true;
            }
            return this._readerContext;
        }

        void readDictIds(int[] docIds, int length, int[] dictIdBuffer) {
            this._reader.readDictIds(docIds, length, dictIdBuffer, this.getReaderContext());
        }

        void readIntValues(int[] docIds, int length, int[] valueBuffer) {
            ForwardIndexReaderContext readerContext = this.getReaderContext();
            if (this._dictionary != null) {
                int[] dictIdBuffer = THREAD_LOCAL_DICT_IDS.get();
                this._reader.readDictIds(docIds, length, dictIdBuffer, readerContext);
                this._dictionary.readIntValues(dictIdBuffer, length, valueBuffer);
            } else {
                switch (this._reader.getValueType()) {
                    case INT: {
                        for (int i = 0; i < length; ++i) {
                            valueBuffer[i] = this._reader.getInt(docIds[i], readerContext);
                        }
                        break;
                    }
                    case LONG: {
                        for (int i = 0; i < length; ++i) {
                            valueBuffer[i] = (int)this._reader.getLong(docIds[i], readerContext);
                        }
                        break;
                    }
                    case FLOAT: {
                        for (int i = 0; i < length; ++i) {
                            valueBuffer[i] = (int)this._reader.getFloat(docIds[i], readerContext);
                        }
                        break;
                    }
                    case DOUBLE: {
                        for (int i = 0; i < length; ++i) {
                            valueBuffer[i] = (int)this._reader.getDouble(docIds[i], readerContext);
                        }
                        break;
                    }
                    case STRING: {
                        for (int i = 0; i < length; ++i) {
                            valueBuffer[i] = Integer.parseInt(this._reader.getString(docIds[i], readerContext));
                        }
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
        }

        void readLongValues(int[] docIds, int length, long[] valueBuffer) {
            ForwardIndexReaderContext readerContext = this.getReaderContext();
            if (this._dictionary != null) {
                int[] dictIdBuffer = THREAD_LOCAL_DICT_IDS.get();
                this._reader.readDictIds(docIds, length, dictIdBuffer, readerContext);
                this._dictionary.readLongValues(dictIdBuffer, length, valueBuffer);
            } else {
                switch (this._reader.getValueType()) {
                    case INT: {
                        for (int i = 0; i < length; ++i) {
                            valueBuffer[i] = this._reader.getInt(docIds[i], readerContext);
                        }
                        break;
                    }
                    case LONG: {
                        for (int i = 0; i < length; ++i) {
                            valueBuffer[i] = this._reader.getLong(docIds[i], readerContext);
                        }
                        break;
                    }
                    case FLOAT: {
                        for (int i = 0; i < length; ++i) {
                            valueBuffer[i] = (long)this._reader.getFloat(docIds[i], readerContext);
                        }
                        break;
                    }
                    case DOUBLE: {
                        for (int i = 0; i < length; ++i) {
                            valueBuffer[i] = (long)this._reader.getDouble(docIds[i], readerContext);
                        }
                        break;
                    }
                    case STRING: {
                        for (int i = 0; i < length; ++i) {
                            valueBuffer[i] = Long.parseLong(this._reader.getString(docIds[i], readerContext));
                        }
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
        }

        void readFloatValues(int[] docIds, int length, float[] valueBuffer) {
            ForwardIndexReaderContext readerContext = this.getReaderContext();
            if (this._dictionary != null) {
                int[] dictIdBuffer = THREAD_LOCAL_DICT_IDS.get();
                this._reader.readDictIds(docIds, length, dictIdBuffer, readerContext);
                this._dictionary.readFloatValues(dictIdBuffer, length, valueBuffer);
            } else {
                switch (this._reader.getValueType()) {
                    case INT: {
                        for (int i = 0; i < length; ++i) {
                            valueBuffer[i] = this._reader.getInt(docIds[i], readerContext);
                        }
                        break;
                    }
                    case LONG: {
                        for (int i = 0; i < length; ++i) {
                            valueBuffer[i] = this._reader.getLong(docIds[i], readerContext);
                        }
                        break;
                    }
                    case FLOAT: {
                        for (int i = 0; i < length; ++i) {
                            valueBuffer[i] = this._reader.getFloat(docIds[i], readerContext);
                        }
                        break;
                    }
                    case DOUBLE: {
                        for (int i = 0; i < length; ++i) {
                            valueBuffer[i] = (float)this._reader.getDouble(docIds[i], readerContext);
                        }
                        break;
                    }
                    case STRING: {
                        for (int i = 0; i < length; ++i) {
                            valueBuffer[i] = Float.parseFloat(this._reader.getString(docIds[i], readerContext));
                        }
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
        }

        void readDoubleValues(int[] docIds, int length, double[] valueBuffer) {
            ForwardIndexReaderContext readerContext = this.getReaderContext();
            if (this._dictionary != null) {
                int[] dictIdBuffer = THREAD_LOCAL_DICT_IDS.get();
                this._reader.readDictIds(docIds, length, dictIdBuffer, readerContext);
                this._dictionary.readDoubleValues(dictIdBuffer, length, valueBuffer);
            } else {
                switch (this._reader.getValueType()) {
                    case INT: {
                        for (int i = 0; i < length; ++i) {
                            valueBuffer[i] = this._reader.getInt(docIds[i], readerContext);
                        }
                        break;
                    }
                    case LONG: {
                        for (int i = 0; i < length; ++i) {
                            valueBuffer[i] = this._reader.getLong(docIds[i], readerContext);
                        }
                        break;
                    }
                    case FLOAT: {
                        for (int i = 0; i < length; ++i) {
                            valueBuffer[i] = this._reader.getFloat(docIds[i], readerContext);
                        }
                        break;
                    }
                    case DOUBLE: {
                        for (int i = 0; i < length; ++i) {
                            valueBuffer[i] = this._reader.getDouble(docIds[i], readerContext);
                        }
                        break;
                    }
                    case STRING: {
                        for (int i = 0; i < length; ++i) {
                            valueBuffer[i] = Double.parseDouble(this._reader.getString(docIds[i], readerContext));
                        }
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
        }

        void readStringValues(int[] docIds, int length, String[] valueBuffer) {
            ForwardIndexReaderContext readerContext = this.getReaderContext();
            if (this._dictionary != null) {
                int[] dictIdBuffer = THREAD_LOCAL_DICT_IDS.get();
                this._reader.readDictIds(docIds, length, dictIdBuffer, readerContext);
                this._dictionary.readStringValues(dictIdBuffer, length, valueBuffer);
            } else {
                switch (this._reader.getValueType()) {
                    case INT: {
                        for (int i = 0; i < length; ++i) {
                            valueBuffer[i] = Integer.toString(this._reader.getInt(docIds[i], readerContext));
                        }
                        break;
                    }
                    case LONG: {
                        for (int i = 0; i < length; ++i) {
                            valueBuffer[i] = Long.toString(this._reader.getLong(docIds[i], readerContext));
                        }
                        break;
                    }
                    case FLOAT: {
                        for (int i = 0; i < length; ++i) {
                            valueBuffer[i] = Float.toString(this._reader.getFloat(docIds[i], readerContext));
                        }
                        break;
                    }
                    case DOUBLE: {
                        for (int i = 0; i < length; ++i) {
                            valueBuffer[i] = Double.toString(this._reader.getDouble(docIds[i], readerContext));
                        }
                        break;
                    }
                    case STRING: {
                        for (int i = 0; i < length; ++i) {
                            valueBuffer[i] = this._reader.getString(docIds[i], readerContext);
                        }
                        break;
                    }
                    case BYTES: {
                        for (int i = 0; i < length; ++i) {
                            valueBuffer[i] = BytesUtils.toHexString((byte[])this._reader.getBytes(docIds[i], readerContext));
                        }
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
        }

        void readBytesValues(int[] docIds, int length, byte[][] valueBuffer) {
            ForwardIndexReaderContext readerContext = this.getReaderContext();
            if (this._dictionary != null) {
                int[] dictIdBuffer = THREAD_LOCAL_DICT_IDS.get();
                this._reader.readDictIds(docIds, length, dictIdBuffer, readerContext);
                this._dictionary.readBytesValues(dictIdBuffer, length, valueBuffer);
            } else {
                switch (this._reader.getValueType()) {
                    case STRING: {
                        for (int i = 0; i < length; ++i) {
                            valueBuffer[i] = BytesUtils.toBytes((String)this._reader.getString(docIds[i], readerContext));
                        }
                        break;
                    }
                    case BYTES: {
                        for (int i = 0; i < length; ++i) {
                            valueBuffer[i] = this._reader.getBytes(docIds[i], readerContext);
                        }
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
        }

        void readDictIdsMV(int[] docIds, int length, int[][] dictIdsBuffer) {
            for (int i = 0; i < length; ++i) {
                int numValues = this._reader.getDictIdMV(docIds[i], DataFetcher.this._reusableMVDictIds, this.getReaderContext());
                dictIdsBuffer[i] = Arrays.copyOfRange(DataFetcher.this._reusableMVDictIds, 0, numValues);
            }
        }

        void readIntValuesMV(int[] docIds, int length, int[][] valuesBuffer) {
            assert (this._dictionary != null);
            for (int i = 0; i < length; ++i) {
                int numValues = this._reader.getDictIdMV(docIds[i], DataFetcher.this._reusableMVDictIds, this.getReaderContext());
                int[] values = new int[numValues];
                this._dictionary.readIntValues(DataFetcher.this._reusableMVDictIds, numValues, values);
                valuesBuffer[i] = values;
            }
        }

        void readLongValuesMV(int[] docIds, int length, long[][] valuesBuffer) {
            assert (this._dictionary != null);
            for (int i = 0; i < length; ++i) {
                int numValues = this._reader.getDictIdMV(docIds[i], DataFetcher.this._reusableMVDictIds, this.getReaderContext());
                long[] values = new long[numValues];
                this._dictionary.readLongValues(DataFetcher.this._reusableMVDictIds, numValues, values);
                valuesBuffer[i] = values;
            }
        }

        void readFloatValuesMV(int[] docIds, int length, float[][] valuesBuffer) {
            assert (this._dictionary != null);
            for (int i = 0; i < length; ++i) {
                int numValues = this._reader.getDictIdMV(docIds[i], DataFetcher.this._reusableMVDictIds, this.getReaderContext());
                float[] values = new float[numValues];
                this._dictionary.readFloatValues(DataFetcher.this._reusableMVDictIds, numValues, values);
                valuesBuffer[i] = values;
            }
        }

        void readDoubleValuesMV(int[] docIds, int length, double[][] valuesBuffer) {
            assert (this._dictionary != null);
            for (int i = 0; i < length; ++i) {
                int numValues = this._reader.getDictIdMV(docIds[i], DataFetcher.this._reusableMVDictIds, this.getReaderContext());
                double[] values = new double[numValues];
                this._dictionary.readDoubleValues(DataFetcher.this._reusableMVDictIds, numValues, values);
                valuesBuffer[i] = values;
            }
        }

        void readStringValuesMV(int[] docIds, int length, String[][] valuesBuffer) {
            assert (this._dictionary != null);
            for (int i = 0; i < length; ++i) {
                int numValues = this._reader.getDictIdMV(docIds[i], DataFetcher.this._reusableMVDictIds, this.getReaderContext());
                String[] values = new String[numValues];
                this._dictionary.readStringValues(DataFetcher.this._reusableMVDictIds, numValues, values);
                valuesBuffer[i] = values;
            }
        }

        public void readNumValuesMV(int[] docIds, int length, int[] numValuesBuffer) {
            for (int i = 0; i < length; ++i) {
                numValuesBuffer[i] = this._reader.getDictIdMV(docIds[i], DataFetcher.this._reusableMVDictIds, this.getReaderContext());
            }
        }

        @Override
        public void close() throws IOException {
            if (this._readerContext != null) {
                this._readerContext.close();
            }
        }
    }
}

