/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.common;

public class MinionConstants {
    public static final String TASK_TIME_SUFFIX = ".time";
    public static final String TASK_BUCKET_GRANULARITY_SUFFIX = ".bucketGranularity";
    public static final String TABLE_NAME_KEY = "tableName";
    public static final String SEGMENT_NAME_KEY = "segmentName";
    public static final String DOWNLOAD_URL_KEY = "downloadURL";
    public static final String UPLOAD_URL_KEY = "uploadURL";
    public static final String DOT_SEPARATOR = ".";
    public static final String URL_SEPARATOR = ",";
    public static final String AUTH_TOKEN = "authToken";
    public static final String ORIGINAL_SEGMENT_CRC_KEY = "crc";
    public static final String MAX_NUM_ATTEMPTS_KEY = "maxNumAttempts";
    public static final String INITIAL_RETRY_DELAY_MS_KEY = "initialRetryDelayMs";
    public static final String RETRY_SCALE_FACTOR_KEY = "retryScaleFactor";
    public static final String TABLE_MAX_NUM_TASKS_KEY = "tableMaxNumTasks";
    public static final String ENABLE_REPLACE_SEGMENTS_KEY = "enableReplaceSegments";

    private MinionConstants() {
    }

    public static class SegmentGenerationAndPushTask {
        public static final String TASK_TYPE = "SegmentGenerationAndPushTask";
        public static final String CONFIG_NUMBER_CONCURRENT_TASKS_PER_INSTANCE = "SegmentGenerationAndPushTask.numConcurrentTasksPerInstance";
    }

    public static class RealtimeToOfflineSegmentsTask {
        public static final String TASK_TYPE = "RealtimeToOfflineSegmentsTask";
        public static final String BUCKET_TIME_PERIOD_KEY = "bucketTimePeriod";
        public static final String BUFFER_TIME_PERIOD_KEY = "bufferTimePeriod";
        public static final String WINDOW_START_MS_KEY = "windowStartMs";
        public static final String WINDOW_END_MS_KEY = "windowEndMs";
        public static final String ROUND_BUCKET_TIME_PERIOD_KEY = "roundBucketTimePeriod";
        public static final String MERGE_TYPE_KEY = "mergeType";
        @Deprecated
        public static final String COLLECTOR_TYPE_KEY = "collectorType";
        public static final String AGGREGATION_TYPE_KEY_SUFFIX = ".aggregationType";
        public static final String MAX_NUM_RECORDS_PER_SEGMENT_KEY = "maxNumRecordsPerSegment";
    }

    public static class MergeRollupTask {
        public static final String TASK_TYPE = "MergeRollupTask";
        public static final String MERGE_TYPE_KEY = "mergeType";
        public static final String GRANULARITY_KEY = "granularity";
        public static final String AGGREGATE_KEY_PREFIX = "aggregate";
        public static final String MERGE_KEY_PREFIX = "merge";
        public static final String BUFFER_TIME = "bufferTime";
        public static final String MAX_NUM_RECORDS_PER_SEGMENT = "maxNumRecordsPerSegment";
        public static final String MAX_NUM_RECORDS_PER_TASK = "maxNumRecordsPerTask";
        public static final String MERGED_SEGMENT_NAME_KEY = "mergedSegmentNameKey";
    }

    public static class PurgeTask {
        public static final String TASK_TYPE = "PurgeTask";
    }

    public static class ConvertToRawIndexTask {
        public static final String TASK_TYPE = "ConvertToRawIndexTask";
        public static final String COLUMNS_TO_CONVERT_KEY = "columnsToConvert";
    }
}

