/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.common;

import com.clearspring.analytics.stream.cardinality.HyperLogLog;
import com.google.common.primitives.Longs;
import com.tdunning.math.stats.MergingDigest;
import com.tdunning.math.stats.TDigest;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleOpenHashSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.floats.FloatOpenHashSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.theta.Sketch;
import org.apache.pinot.common.utils.StringUtil;
import org.apache.pinot.core.query.distinct.DistinctTable;
import org.apache.pinot.core.query.utils.idset.IdSet;
import org.apache.pinot.core.query.utils.idset.IdSets;
import org.apache.pinot.segment.local.customobject.AvgPair;
import org.apache.pinot.segment.local.customobject.MinMaxRangePair;
import org.apache.pinot.segment.local.customobject.QuantileDigest;
import org.apache.pinot.segment.local.utils.GeometrySerializer;
import org.apache.pinot.spi.utils.BigDecimalUtils;
import org.apache.pinot.spi.utils.ByteArray;
import org.apache.pinot.spi.utils.StringUtils;
import org.locationtech.jts.geom.Geometry;
import org.roaringbitmap.RoaringBitmap;

public class ObjectSerDeUtils {
    public static final ObjectSerDe<String> STRING_SER_DE = new ObjectSerDe<String>(){

        @Override
        public byte[] serialize(String value) {
            return StringUtil.encodeUtf8((String)value);
        }

        @Override
        public String deserialize(byte[] bytes) {
            return StringUtil.decodeUtf8((byte[])bytes);
        }

        @Override
        public String deserialize(ByteBuffer byteBuffer) {
            byte[] bytes = new byte[byteBuffer.remaining()];
            byteBuffer.get(bytes);
            return StringUtil.decodeUtf8((byte[])bytes);
        }
    };
    public static final ObjectSerDe<Long> LONG_SER_DE = new ObjectSerDe<Long>(){

        @Override
        public byte[] serialize(Long value) {
            return Longs.toByteArray((long)value);
        }

        @Override
        public Long deserialize(byte[] bytes) {
            return Longs.fromByteArray((byte[])bytes);
        }

        @Override
        public Long deserialize(ByteBuffer byteBuffer) {
            return byteBuffer.getLong();
        }
    };
    public static final ObjectSerDe<Double> DOUBLE_SER_DE = new ObjectSerDe<Double>(){

        @Override
        public byte[] serialize(Double value) {
            return Longs.toByteArray((long)Double.doubleToRawLongBits(value));
        }

        @Override
        public Double deserialize(byte[] bytes) {
            return Double.longBitsToDouble(Longs.fromByteArray((byte[])bytes));
        }

        @Override
        public Double deserialize(ByteBuffer byteBuffer) {
            return byteBuffer.getDouble();
        }
    };
    public static final ObjectSerDe<DoubleArrayList> DOUBLE_ARRAY_LIST_SER_DE = new ObjectSerDe<DoubleArrayList>(){

        @Override
        public byte[] serialize(DoubleArrayList doubleArrayList) {
            int size = doubleArrayList.size();
            byte[] bytes = new byte[4 + size * 8];
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
            byteBuffer.putInt(size);
            double[] values = doubleArrayList.elements();
            for (int i = 0; i < size; ++i) {
                byteBuffer.putDouble(values[i]);
            }
            return bytes;
        }

        @Override
        public DoubleArrayList deserialize(byte[] bytes) {
            return this.deserialize(ByteBuffer.wrap(bytes));
        }

        @Override
        public DoubleArrayList deserialize(ByteBuffer byteBuffer) {
            int numValues = byteBuffer.getInt();
            DoubleArrayList doubleArrayList = new DoubleArrayList(numValues);
            for (int i = 0; i < numValues; ++i) {
                doubleArrayList.add(byteBuffer.getDouble());
            }
            return doubleArrayList;
        }
    };
    public static final ObjectSerDe<AvgPair> AVG_PAIR_SER_DE = new ObjectSerDe<AvgPair>(){

        @Override
        public byte[] serialize(AvgPair avgPair) {
            return avgPair.toBytes();
        }

        @Override
        public AvgPair deserialize(byte[] bytes) {
            return AvgPair.fromBytes((byte[])bytes);
        }

        @Override
        public AvgPair deserialize(ByteBuffer byteBuffer) {
            return AvgPair.fromByteBuffer((ByteBuffer)byteBuffer);
        }
    };
    public static final ObjectSerDe<MinMaxRangePair> MIN_MAX_RANGE_PAIR_SER_DE = new ObjectSerDe<MinMaxRangePair>(){

        @Override
        public byte[] serialize(MinMaxRangePair minMaxRangePair) {
            return minMaxRangePair.toBytes();
        }

        @Override
        public MinMaxRangePair deserialize(byte[] bytes) {
            return MinMaxRangePair.fromBytes((byte[])bytes);
        }

        @Override
        public MinMaxRangePair deserialize(ByteBuffer byteBuffer) {
            return MinMaxRangePair.fromByteBuffer((ByteBuffer)byteBuffer);
        }
    };
    public static final ObjectSerDe<HyperLogLog> HYPER_LOG_LOG_SER_DE = new ObjectSerDe<HyperLogLog>(){

        @Override
        public byte[] serialize(HyperLogLog hyperLogLog) {
            try {
                return hyperLogLog.getBytes();
            }
            catch (IOException e) {
                throw new RuntimeException("Caught exception while serializing HyperLogLog", e);
            }
        }

        @Override
        public HyperLogLog deserialize(byte[] bytes) {
            try {
                return HyperLogLog.Builder.build((byte[])bytes);
            }
            catch (IOException e) {
                throw new RuntimeException("Caught exception while de-serializing HyperLogLog", e);
            }
        }

        @Override
        public HyperLogLog deserialize(ByteBuffer byteBuffer) {
            byte[] bytes = new byte[byteBuffer.remaining()];
            byteBuffer.get(bytes);
            try {
                return HyperLogLog.Builder.build((byte[])bytes);
            }
            catch (IOException e) {
                throw new RuntimeException("Caught exception while de-serializing HyperLogLog", e);
            }
        }
    };
    public static final ObjectSerDe<DistinctTable> DISTINCT_TABLE_SER_DE = new ObjectSerDe<DistinctTable>(){

        @Override
        public byte[] serialize(DistinctTable distinctTable) {
            try {
                return distinctTable.toBytes();
            }
            catch (IOException e) {
                throw new IllegalStateException("Caught exception while serializing DistinctTable", e);
            }
        }

        @Override
        public DistinctTable deserialize(byte[] bytes) {
            try {
                return DistinctTable.fromByteBuffer(ByteBuffer.wrap(bytes));
            }
            catch (IOException e) {
                throw new IllegalStateException("Caught exception while de-serializing DistinctTable", e);
            }
        }

        @Override
        public DistinctTable deserialize(ByteBuffer byteBuffer) {
            try {
                return DistinctTable.fromByteBuffer(byteBuffer);
            }
            catch (IOException e) {
                throw new IllegalStateException("Caught exception while de-serializing DistinctTable", e);
            }
        }
    };
    public static final ObjectSerDe<QuantileDigest> QUANTILE_DIGEST_SER_DE = new ObjectSerDe<QuantileDigest>(){

        @Override
        public byte[] serialize(QuantileDigest quantileDigest) {
            return quantileDigest.toBytes();
        }

        @Override
        public QuantileDigest deserialize(byte[] bytes) {
            return QuantileDigest.fromBytes((byte[])bytes);
        }

        @Override
        public QuantileDigest deserialize(ByteBuffer byteBuffer) {
            return QuantileDigest.fromByteBuffer((ByteBuffer)byteBuffer);
        }
    };
    public static final ObjectSerDe<Map<Object, Object>> MAP_SER_DE = new ObjectSerDe<Map<Object, Object>>(){

        @Override
        public byte[] serialize(Map<Object, Object> map) {
            int size = map.size();
            if (size == 0) {
                return new byte[4];
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            try {
                dataOutputStream.writeInt(size);
                Iterator<Map.Entry<Object, Object>> iterator = map.entrySet().iterator();
                Map.Entry<Object, Object> firstEntry = iterator.next();
                Object firstKey = firstEntry.getKey();
                Object firstValue = firstEntry.getValue();
                int keyTypeValue = ObjectType.getObjectType(firstKey).getValue();
                int valueTypeValue = ObjectType.getObjectType(firstValue).getValue();
                dataOutputStream.writeInt(keyTypeValue);
                dataOutputStream.writeInt(valueTypeValue);
                for (Map.Entry<Object, Object> entry : map.entrySet()) {
                    byte[] keyBytes = ObjectSerDeUtils.serialize(entry.getKey(), keyTypeValue);
                    dataOutputStream.writeInt(keyBytes.length);
                    dataOutputStream.write(keyBytes);
                    byte[] valueBytes = ObjectSerDeUtils.serialize(entry.getValue(), valueTypeValue);
                    dataOutputStream.writeInt(valueBytes.length);
                    dataOutputStream.write(valueBytes);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Caught exception while serializing Map", e);
            }
            return byteArrayOutputStream.toByteArray();
        }

        @Override
        public HashMap<Object, Object> deserialize(byte[] bytes) {
            return this.deserialize(ByteBuffer.wrap(bytes));
        }

        @Override
        public HashMap<Object, Object> deserialize(ByteBuffer byteBuffer) {
            int size = byteBuffer.getInt();
            HashMap<Object, Object> map = new HashMap<Object, Object>(size);
            if (size == 0) {
                return map;
            }
            int keyTypeValue = byteBuffer.getInt();
            int valueTypeValue = byteBuffer.getInt();
            for (int i = 0; i < size; ++i) {
                Object key = ObjectSerDeUtils.deserialize(this.sliceByteBuffer(byteBuffer, byteBuffer.getInt()), keyTypeValue);
                Object value = ObjectSerDeUtils.deserialize(this.sliceByteBuffer(byteBuffer, byteBuffer.getInt()), valueTypeValue);
                map.put(key, value);
            }
            return map;
        }

        private ByteBuffer sliceByteBuffer(ByteBuffer byteBuffer, int size) {
            ByteBuffer slice = byteBuffer.slice();
            slice.limit(size);
            byteBuffer.position(byteBuffer.position() + size);
            return slice;
        }
    };
    public static final ObjectSerDe<IntSet> INT_SET_SER_DE = new ObjectSerDe<IntSet>(){

        @Override
        public byte[] serialize(IntSet intSet) {
            int size = intSet.size();
            byte[] bytes = new byte[4 + size * 4];
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
            byteBuffer.putInt(size);
            IntIterator iterator = intSet.iterator();
            while (iterator.hasNext()) {
                byteBuffer.putInt(iterator.nextInt());
            }
            return bytes;
        }

        @Override
        public IntOpenHashSet deserialize(byte[] bytes) {
            return this.deserialize(ByteBuffer.wrap(bytes));
        }

        @Override
        public IntOpenHashSet deserialize(ByteBuffer byteBuffer) {
            int size = byteBuffer.getInt();
            IntOpenHashSet intSet = new IntOpenHashSet(size);
            for (int i = 0; i < size; ++i) {
                intSet.add(byteBuffer.getInt());
            }
            return intSet;
        }
    };
    public static final ObjectSerDe<LongSet> LONG_SET_SER_DE = new ObjectSerDe<LongSet>(){

        @Override
        public byte[] serialize(LongSet longSet) {
            int size = longSet.size();
            byte[] bytes = new byte[4 + size * 8];
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
            byteBuffer.putInt(size);
            LongIterator iterator = longSet.iterator();
            while (iterator.hasNext()) {
                byteBuffer.putLong(iterator.nextLong());
            }
            return bytes;
        }

        @Override
        public LongOpenHashSet deserialize(byte[] bytes) {
            return this.deserialize(ByteBuffer.wrap(bytes));
        }

        @Override
        public LongOpenHashSet deserialize(ByteBuffer byteBuffer) {
            int size = byteBuffer.getInt();
            LongOpenHashSet longSet = new LongOpenHashSet(size);
            for (int i = 0; i < size; ++i) {
                longSet.add(byteBuffer.getLong());
            }
            return longSet;
        }
    };
    public static final ObjectSerDe<FloatSet> FLOAT_SET_SER_DE = new ObjectSerDe<FloatSet>(){

        @Override
        public byte[] serialize(FloatSet floatSet) {
            int size = floatSet.size();
            byte[] bytes = new byte[4 + size * 4];
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
            byteBuffer.putInt(size);
            FloatIterator iterator = floatSet.iterator();
            while (iterator.hasNext()) {
                byteBuffer.putFloat(iterator.nextFloat());
            }
            return bytes;
        }

        @Override
        public FloatOpenHashSet deserialize(byte[] bytes) {
            return this.deserialize(ByteBuffer.wrap(bytes));
        }

        @Override
        public FloatOpenHashSet deserialize(ByteBuffer byteBuffer) {
            int size = byteBuffer.getInt();
            FloatOpenHashSet floatSet = new FloatOpenHashSet(size);
            for (int i = 0; i < size; ++i) {
                floatSet.add(byteBuffer.getFloat());
            }
            return floatSet;
        }
    };
    public static final ObjectSerDe<DoubleSet> DOUBLE_SET_SER_DE = new ObjectSerDe<DoubleSet>(){

        @Override
        public byte[] serialize(DoubleSet doubleSet) {
            int size = doubleSet.size();
            byte[] bytes = new byte[4 + size * 8];
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
            byteBuffer.putInt(size);
            DoubleIterator iterator = doubleSet.iterator();
            while (iterator.hasNext()) {
                byteBuffer.putDouble(iterator.nextDouble());
            }
            return bytes;
        }

        @Override
        public DoubleOpenHashSet deserialize(byte[] bytes) {
            return this.deserialize(ByteBuffer.wrap(bytes));
        }

        @Override
        public DoubleOpenHashSet deserialize(ByteBuffer byteBuffer) {
            int size = byteBuffer.getInt();
            DoubleOpenHashSet doubleSet = new DoubleOpenHashSet(size);
            for (int i = 0; i < size; ++i) {
                doubleSet.add(byteBuffer.getDouble());
            }
            return doubleSet;
        }
    };
    public static final ObjectSerDe<Set<String>> STRING_SET_SER_DE = new ObjectSerDe<Set<String>>(){

        @Override
        public byte[] serialize(Set<String> stringSet) {
            int size = stringSet.size();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            try {
                dataOutputStream.writeInt(size);
                for (String value : stringSet) {
                    byte[] bytes = StringUtils.encodeUtf8((String)value);
                    dataOutputStream.writeInt(bytes.length);
                    dataOutputStream.write(bytes);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Caught exception while serializing Set<String>", e);
            }
            return byteArrayOutputStream.toByteArray();
        }

        @Override
        public ObjectOpenHashSet<String> deserialize(byte[] bytes) {
            return this.deserialize(ByteBuffer.wrap(bytes));
        }

        @Override
        public ObjectOpenHashSet<String> deserialize(ByteBuffer byteBuffer) {
            int size = byteBuffer.getInt();
            ObjectOpenHashSet stringSet = new ObjectOpenHashSet(size);
            for (int i = 0; i < size; ++i) {
                int length = byteBuffer.getInt();
                byte[] bytes = new byte[length];
                byteBuffer.get(bytes);
                stringSet.add((Object)StringUtils.decodeUtf8((byte[])bytes));
            }
            return stringSet;
        }
    };
    public static final ObjectSerDe<Set<ByteArray>> BYTES_SET_SER_DE = new ObjectSerDe<Set<ByteArray>>(){

        @Override
        public byte[] serialize(Set<ByteArray> bytesSet) {
            int size = bytesSet.size();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            try {
                dataOutputStream.writeInt(size);
                for (ByteArray value : bytesSet) {
                    byte[] bytes = value.getBytes();
                    dataOutputStream.writeInt(bytes.length);
                    dataOutputStream.write(bytes);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Caught exception while serializing Set<ByteArray>", e);
            }
            return byteArrayOutputStream.toByteArray();
        }

        @Override
        public ObjectOpenHashSet<ByteArray> deserialize(byte[] bytes) {
            return this.deserialize(ByteBuffer.wrap(bytes));
        }

        @Override
        public ObjectOpenHashSet<ByteArray> deserialize(ByteBuffer byteBuffer) {
            int size = byteBuffer.getInt();
            ObjectOpenHashSet bytesSet = new ObjectOpenHashSet(size);
            for (int i = 0; i < size; ++i) {
                int length = byteBuffer.getInt();
                byte[] bytes = new byte[length];
                byteBuffer.get(bytes);
                bytesSet.add((Object)new ByteArray(bytes));
            }
            return bytesSet;
        }
    };
    public static final ObjectSerDe<TDigest> TDIGEST_SER_DE = new ObjectSerDe<TDigest>(){

        @Override
        public byte[] serialize(TDigest tDigest) {
            byte[] bytes = new byte[tDigest.byteSize()];
            tDigest.asBytes(ByteBuffer.wrap(bytes));
            return bytes;
        }

        @Override
        public TDigest deserialize(byte[] bytes) {
            return MergingDigest.fromBytes((ByteBuffer)ByteBuffer.wrap(bytes));
        }

        @Override
        public TDigest deserialize(ByteBuffer byteBuffer) {
            return MergingDigest.fromBytes((ByteBuffer)byteBuffer);
        }
    };
    public static final ObjectSerDe<Sketch> DATA_SKETCH_SER_DE = new ObjectSerDe<Sketch>(){

        @Override
        public byte[] serialize(Sketch value) {
            return value.compact(false, null).toByteArray();
        }

        @Override
        public Sketch deserialize(byte[] bytes) {
            return Sketch.wrap((Memory)Memory.wrap((byte[])bytes));
        }

        @Override
        public Sketch deserialize(ByteBuffer byteBuffer) {
            byte[] bytes = new byte[byteBuffer.remaining()];
            byteBuffer.get(bytes);
            return Sketch.wrap((Memory)Memory.wrap((byte[])bytes));
        }
    };
    public static final ObjectSerDe<Geometry> GEOMETRY_SER_DE = new ObjectSerDe<Geometry>(){

        @Override
        public byte[] serialize(Geometry value) {
            return GeometrySerializer.serialize((Geometry)value);
        }

        @Override
        public Geometry deserialize(byte[] bytes) {
            return GeometrySerializer.deserialize((byte[])bytes);
        }

        @Override
        public Geometry deserialize(ByteBuffer byteBuffer) {
            byte[] bytes = new byte[byteBuffer.remaining()];
            byteBuffer.get(bytes);
            return GeometrySerializer.deserialize((byte[])bytes);
        }
    };
    public static final ObjectSerDe<RoaringBitmap> ROARING_BITMAP_SER_DE = new ObjectSerDe<RoaringBitmap>(){

        @Override
        public byte[] serialize(RoaringBitmap bitmap) {
            byte[] bytes = new byte[bitmap.serializedSizeInBytes()];
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
            bitmap.serialize(byteBuffer);
            return bytes;
        }

        @Override
        public RoaringBitmap deserialize(byte[] bytes) {
            return this.deserialize(ByteBuffer.wrap(bytes));
        }

        @Override
        public RoaringBitmap deserialize(ByteBuffer byteBuffer) {
            RoaringBitmap bitmap = new RoaringBitmap();
            try {
                bitmap.deserialize(byteBuffer);
            }
            catch (IOException e) {
                throw new RuntimeException("Caught exception while deserializing RoaringBitmap", e);
            }
            return bitmap;
        }
    };
    public static final ObjectSerDe<IdSet> ID_SET_SER_DE = new ObjectSerDe<IdSet>(){

        @Override
        public byte[] serialize(IdSet idSet) {
            try {
                return idSet.toBytes();
            }
            catch (IOException e) {
                throw new RuntimeException("Caught exception while serializing IdSet", e);
            }
        }

        @Override
        public IdSet deserialize(byte[] bytes) {
            try {
                return IdSets.fromBytes(bytes);
            }
            catch (IOException e) {
                throw new RuntimeException("Caught exception while deserializing IdSet", e);
            }
        }

        @Override
        public IdSet deserialize(ByteBuffer byteBuffer) {
            try {
                return IdSets.fromByteBuffer(byteBuffer);
            }
            catch (IOException e) {
                throw new RuntimeException("Caught exception while deserializing IdSet", e);
            }
        }
    };
    public static final ObjectSerDe<List<Object>> LIST_SER_DE = new ObjectSerDe<List<Object>>(){

        @Override
        public byte[] serialize(List<Object> list) {
            int size = list.size();
            if (size == 0) {
                return new byte[4];
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            try {
                dataOutputStream.writeInt(size);
                Object firstValue = list.get(0);
                int valueType = ObjectType.getObjectType(firstValue).getValue();
                dataOutputStream.writeInt(valueType);
                for (Object value : list) {
                    byte[] bytes = ObjectSerDeUtils.serialize(value, valueType);
                    dataOutputStream.writeInt(bytes.length);
                    dataOutputStream.write(bytes);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Caught exception while serializing List", e);
            }
            return byteArrayOutputStream.toByteArray();
        }

        @Override
        public ArrayList<Object> deserialize(byte[] bytes) {
            return this.deserialize(ByteBuffer.wrap(bytes));
        }

        @Override
        public ArrayList<Object> deserialize(ByteBuffer byteBuffer) {
            int size = byteBuffer.getInt();
            ArrayList<Object> list = new ArrayList<Object>(size);
            if (size != 0) {
                int valueType = byteBuffer.getInt();
                for (int i = 0; i < size; ++i) {
                    int numBytes = byteBuffer.getInt();
                    ByteBuffer slice = byteBuffer.slice();
                    slice.limit(numBytes);
                    list.add(ObjectSerDeUtils.deserialize(slice, valueType));
                    byteBuffer.position(byteBuffer.position() + numBytes);
                }
            }
            return list;
        }
    };
    public static final ObjectSerDe<BigDecimal> BIGDECIMAL_SER_DE = new ObjectSerDe<BigDecimal>(){

        @Override
        public byte[] serialize(BigDecimal value) {
            return BigDecimalUtils.serialize((BigDecimal)value);
        }

        @Override
        public BigDecimal deserialize(byte[] bytes) {
            return BigDecimalUtils.deserialize((byte[])bytes);
        }

        @Override
        public BigDecimal deserialize(ByteBuffer byteBuffer) {
            byte[] bytes = new byte[byteBuffer.remaining()];
            byteBuffer.get(bytes);
            return BigDecimalUtils.deserialize((byte[])bytes);
        }
    };
    private static final ObjectSerDe[] SER_DES = new ObjectSerDe[]{STRING_SER_DE, LONG_SER_DE, DOUBLE_SER_DE, DOUBLE_ARRAY_LIST_SER_DE, AVG_PAIR_SER_DE, MIN_MAX_RANGE_PAIR_SER_DE, HYPER_LOG_LOG_SER_DE, QUANTILE_DIGEST_SER_DE, MAP_SER_DE, INT_SET_SER_DE, TDIGEST_SER_DE, DISTINCT_TABLE_SER_DE, DATA_SKETCH_SER_DE, GEOMETRY_SER_DE, ROARING_BITMAP_SER_DE, LONG_SET_SER_DE, FLOAT_SET_SER_DE, DOUBLE_SET_SER_DE, STRING_SET_SER_DE, BYTES_SET_SER_DE, ID_SET_SER_DE, LIST_SER_DE, BIGDECIMAL_SER_DE};

    private ObjectSerDeUtils() {
    }

    public static byte[] serialize(Object value) {
        return ObjectSerDeUtils.serialize(value, ObjectType.getObjectType((Object)value)._value);
    }

    public static byte[] serialize(Object value, ObjectType objectType) {
        return ObjectSerDeUtils.serialize(value, objectType._value);
    }

    public static byte[] serialize(Object value, int objectTypeValue) {
        return SER_DES[objectTypeValue].serialize(value);
    }

    public static <T> T deserialize(byte[] bytes, ObjectType objectType) {
        return ObjectSerDeUtils.deserialize(bytes, objectType._value);
    }

    public static <T> T deserialize(byte[] bytes, int objectTypeValue) {
        return SER_DES[objectTypeValue].deserialize(bytes);
    }

    public static <T> T deserialize(ByteBuffer byteBuffer, ObjectType objectType) {
        return ObjectSerDeUtils.deserialize(byteBuffer, objectType._value);
    }

    public static <T> T deserialize(ByteBuffer byteBuffer, int objectTypeValue) {
        return SER_DES[objectTypeValue].deserialize(byteBuffer);
    }

    public static interface ObjectSerDe<T> {
        public byte[] serialize(T var1);

        public T deserialize(byte[] var1);

        public T deserialize(ByteBuffer var1);
    }

    public static enum ObjectType {
        String(0),
        Long(1),
        Double(2),
        DoubleArrayList(3),
        AvgPair(4),
        MinMaxRangePair(5),
        HyperLogLog(6),
        QuantileDigest(7),
        Map(8),
        IntSet(9),
        TDigest(10),
        DistinctTable(11),
        DataSketch(12),
        Geometry(13),
        RoaringBitmap(14),
        LongSet(15),
        FloatSet(16),
        DoubleSet(17),
        StringSet(18),
        BytesSet(19),
        IdSet(20),
        List(21),
        BigDecimal(22);

        private final int _value;

        private ObjectType(int value) {
            this._value = value;
        }

        public int getValue() {
            return this._value;
        }

        public static ObjectType getObjectType(Object value) {
            if (value instanceof String) {
                return String;
            }
            if (value instanceof Long) {
                return Long;
            }
            if (value instanceof Double) {
                return Double;
            }
            if (value instanceof BigDecimal) {
                return BigDecimal;
            }
            if (value instanceof DoubleArrayList) {
                return DoubleArrayList;
            }
            if (value instanceof AvgPair) {
                return AvgPair;
            }
            if (value instanceof MinMaxRangePair) {
                return MinMaxRangePair;
            }
            if (value instanceof HyperLogLog) {
                return HyperLogLog;
            }
            if (value instanceof QuantileDigest) {
                return QuantileDigest;
            }
            if (value instanceof Map) {
                return Map;
            }
            if (value instanceof IntSet) {
                return IntSet;
            }
            if (value instanceof TDigest) {
                return TDigest;
            }
            if (value instanceof DistinctTable) {
                return DistinctTable;
            }
            if (value instanceof Sketch) {
                return DataSketch;
            }
            if (value instanceof Geometry) {
                return Geometry;
            }
            if (value instanceof RoaringBitmap) {
                return RoaringBitmap;
            }
            if (value instanceof LongSet) {
                return LongSet;
            }
            if (value instanceof FloatSet) {
                return FloatSet;
            }
            if (value instanceof DoubleSet) {
                return DoubleSet;
            }
            if (value instanceof ObjectSet) {
                ObjectSet objectSet = (ObjectSet)value;
                if (objectSet.isEmpty() || objectSet.iterator().next() instanceof String) {
                    return StringSet;
                }
                return BytesSet;
            }
            if (value instanceof IdSet) {
                return IdSet;
            }
            if (value instanceof List) {
                return List;
            }
            throw new IllegalArgumentException("Unsupported type of value: " + value.getClass().getSimpleName());
        }
    }
}

