/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.common.datatable;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.DataTable;
import org.apache.pinot.common.utils.StringUtil;
import org.apache.pinot.core.common.ObjectSerDeUtils;
import org.apache.pinot.core.common.datatable.DataTableUtils;
import org.apache.pinot.spi.utils.ByteArray;
import org.apache.pinot.spi.utils.BytesUtils;

public abstract class BaseDataTable
implements DataTable {
    protected int _numRows;
    protected int _numColumns;
    protected DataSchema _dataSchema;
    protected int[] _columnOffsets;
    protected int _rowSizeInBytes;
    protected Map<String, Map<Integer, String>> _dictionaryMap;
    protected byte[] _fixedSizeDataBytes;
    protected ByteBuffer _fixedSizeData;
    protected byte[] _variableSizeDataBytes;
    protected ByteBuffer _variableSizeData;
    protected Map<String, String> _metadata;

    public BaseDataTable(int numRows, DataSchema dataSchema, Map<String, Map<Integer, String>> dictionaryMap, byte[] fixedSizeDataBytes, byte[] variableSizeDataBytes) {
        this._numRows = numRows;
        this._numColumns = dataSchema.size();
        this._dataSchema = dataSchema;
        this._columnOffsets = new int[this._numColumns];
        this._rowSizeInBytes = DataTableUtils.computeColumnOffsets(dataSchema, this._columnOffsets);
        this._dictionaryMap = dictionaryMap;
        this._fixedSizeDataBytes = fixedSizeDataBytes;
        this._fixedSizeData = ByteBuffer.wrap(fixedSizeDataBytes);
        this._variableSizeDataBytes = variableSizeDataBytes;
        this._variableSizeData = ByteBuffer.wrap(variableSizeDataBytes);
        this._metadata = new HashMap<String, String>();
    }

    public BaseDataTable() {
        this._numRows = 0;
        this._numColumns = 0;
        this._dataSchema = null;
        this._columnOffsets = null;
        this._rowSizeInBytes = 0;
        this._dictionaryMap = null;
        this._fixedSizeDataBytes = null;
        this._fixedSizeData = null;
        this._variableSizeDataBytes = null;
        this._variableSizeData = null;
        this._metadata = new HashMap<String, String>();
    }

    protected byte[] serializeDictionaryMap() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(this._dictionaryMap.size());
        for (Map.Entry<String, Map<Integer, String>> dictionaryMapEntry : this._dictionaryMap.entrySet()) {
            String columnName = dictionaryMapEntry.getKey();
            Map<Integer, String> dictionary = dictionaryMapEntry.getValue();
            byte[] bytes = StringUtil.encodeUtf8((String)columnName);
            dataOutputStream.writeInt(bytes.length);
            dataOutputStream.write(bytes);
            dataOutputStream.writeInt(dictionary.size());
            for (Map.Entry<Integer, String> dictionaryEntry : dictionary.entrySet()) {
                dataOutputStream.writeInt(dictionaryEntry.getKey());
                byte[] valueBytes = StringUtil.encodeUtf8((String)dictionaryEntry.getValue());
                dataOutputStream.writeInt(valueBytes.length);
                dataOutputStream.write(valueBytes);
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    protected Map<String, Map<Integer, String>> deserializeDictionaryMap(byte[] bytes) throws IOException {
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);){
            HashMap<String, Map<Integer, String>> hashMap;
            try (DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);){
                int numDictionaries = dataInputStream.readInt();
                HashMap<String, Map<Integer, String>> dictionaryMap = new HashMap<String, Map<Integer, String>>(numDictionaries);
                for (int i = 0; i < numDictionaries; ++i) {
                    String column = DataTableUtils.decodeString(dataInputStream);
                    int dictionarySize = dataInputStream.readInt();
                    HashMap<Integer, String> dictionary = new HashMap<Integer, String>(dictionarySize);
                    for (int j = 0; j < dictionarySize; ++j) {
                        int key = dataInputStream.readInt();
                        String value = DataTableUtils.decodeString(dataInputStream);
                        dictionary.put(key, value);
                    }
                    dictionaryMap.put(column, dictionary);
                }
                hashMap = dictionaryMap;
            }
            return hashMap;
        }
    }

    public Map<String, String> getMetadata() {
        return this._metadata;
    }

    public DataSchema getDataSchema() {
        return this._dataSchema;
    }

    public int getNumberOfRows() {
        return this._numRows;
    }

    public int getInt(int rowId, int colId) {
        this._fixedSizeData.position(rowId * this._rowSizeInBytes + this._columnOffsets[colId]);
        return this._fixedSizeData.getInt();
    }

    public long getLong(int rowId, int colId) {
        this._fixedSizeData.position(rowId * this._rowSizeInBytes + this._columnOffsets[colId]);
        return this._fixedSizeData.getLong();
    }

    public float getFloat(int rowId, int colId) {
        this._fixedSizeData.position(rowId * this._rowSizeInBytes + this._columnOffsets[colId]);
        return this._fixedSizeData.getFloat();
    }

    public double getDouble(int rowId, int colId) {
        this._fixedSizeData.position(rowId * this._rowSizeInBytes + this._columnOffsets[colId]);
        return this._fixedSizeData.getDouble();
    }

    public String getString(int rowId, int colId) {
        this._fixedSizeData.position(rowId * this._rowSizeInBytes + this._columnOffsets[colId]);
        int dictId = this._fixedSizeData.getInt();
        return this._dictionaryMap.get(this._dataSchema.getColumnName(colId)).get(dictId);
    }

    public ByteArray getBytes(int rowId, int colId) {
        return BytesUtils.toByteArray((String)this.getString(rowId, colId));
    }

    public <T> T getObject(int rowId, int colId) {
        int size = this.positionCursorInVariableBuffer(rowId, colId);
        int objectTypeValue = this._variableSizeData.getInt();
        ByteBuffer byteBuffer = this._variableSizeData.slice();
        byteBuffer.limit(size);
        return ObjectSerDeUtils.deserialize(byteBuffer, objectTypeValue);
    }

    public int[] getIntArray(int rowId, int colId) {
        int length = this.positionCursorInVariableBuffer(rowId, colId);
        int[] ints = new int[length];
        for (int i = 0; i < length; ++i) {
            ints[i] = this._variableSizeData.getInt();
        }
        return ints;
    }

    public long[] getLongArray(int rowId, int colId) {
        int length = this.positionCursorInVariableBuffer(rowId, colId);
        long[] longs = new long[length];
        for (int i = 0; i < length; ++i) {
            longs[i] = this._variableSizeData.getLong();
        }
        return longs;
    }

    public float[] getFloatArray(int rowId, int colId) {
        int length = this.positionCursorInVariableBuffer(rowId, colId);
        float[] floats = new float[length];
        for (int i = 0; i < length; ++i) {
            floats[i] = this._variableSizeData.getFloat();
        }
        return floats;
    }

    public double[] getDoubleArray(int rowId, int colId) {
        int length = this.positionCursorInVariableBuffer(rowId, colId);
        double[] doubles = new double[length];
        for (int i = 0; i < length; ++i) {
            doubles[i] = this._variableSizeData.getDouble();
        }
        return doubles;
    }

    public String[] getStringArray(int rowId, int colId) {
        int length = this.positionCursorInVariableBuffer(rowId, colId);
        String[] strings = new String[length];
        Map<Integer, String> dictionary = this._dictionaryMap.get(this._dataSchema.getColumnName(colId));
        for (int i = 0; i < length; ++i) {
            strings[i] = dictionary.get(this._variableSizeData.getInt());
        }
        return strings;
    }

    private int positionCursorInVariableBuffer(int rowId, int colId) {
        this._fixedSizeData.position(rowId * this._rowSizeInBytes + this._columnOffsets[colId]);
        this._variableSizeData.position(this._fixedSizeData.getInt());
        return this._fixedSizeData.getInt();
    }

    public String toString() {
        if (this._dataSchema == null) {
            return this._metadata.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this._dataSchema.toString()).append('\n');
        stringBuilder.append("numRows: ").append(this._numRows).append('\n');
        DataSchema.ColumnDataType[] storedColumnDataTypes = this._dataSchema.getStoredColumnDataTypes();
        this._fixedSizeData.position(0);
        for (int rowId = 0; rowId < this._numRows; ++rowId) {
            for (int colId = 0; colId < this._numColumns; ++colId) {
                switch (storedColumnDataTypes[colId]) {
                    case INT: {
                        stringBuilder.append(this._fixedSizeData.getInt());
                        break;
                    }
                    case LONG: {
                        stringBuilder.append(this._fixedSizeData.getLong());
                        break;
                    }
                    case FLOAT: {
                        stringBuilder.append(this._fixedSizeData.getFloat());
                        break;
                    }
                    case DOUBLE: {
                        stringBuilder.append(this._fixedSizeData.getDouble());
                        break;
                    }
                    case STRING: {
                        stringBuilder.append(this._fixedSizeData.getInt());
                        break;
                    }
                    default: {
                        stringBuilder.append(String.format("(%s:%s)", this._fixedSizeData.getInt(), this._fixedSizeData.getInt()));
                    }
                }
                stringBuilder.append("\t");
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }
}

