/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.common.datatable;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.pinot.common.utils.DataTable;
import org.apache.pinot.core.common.datatable.DataTableImplV2;
import org.apache.pinot.core.common.datatable.DataTableImplV3;

public class DataTableFactory {
    private DataTableFactory() {
    }

    public static DataTable getDataTable(ByteBuffer byteBuffer) throws IOException {
        int version = byteBuffer.getInt();
        switch (version) {
            case 2: {
                return new DataTableImplV2(byteBuffer);
            }
            case 3: {
                return new DataTableImplV3(byteBuffer);
            }
        }
        throw new UnsupportedOperationException("Unsupported data table version: " + version);
    }

    public static DataTable getDataTable(byte[] bytes) throws IOException {
        return DataTableFactory.getDataTable(ByteBuffer.wrap(bytes));
    }
}

