/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.common.datatable;

import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.pinot.common.response.ProcessingException;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.DataTable;
import org.apache.pinot.common.utils.StringUtil;
import org.apache.pinot.core.common.datatable.BaseDataTable;
import org.apache.pinot.core.common.datatable.DataTableUtils;
import org.apache.pinot.core.query.request.context.ThreadTimer;

public class DataTableImplV3
extends BaseDataTable {
    private static final int HEADER_SIZE = 52;
    private final Map<Integer, String> _errCodeToExceptionMap;

    public DataTableImplV3(int numRows, DataSchema dataSchema, Map<String, Map<Integer, String>> dictionaryMap, byte[] fixedSizeDataBytes, byte[] variableSizeDataBytes) {
        super(numRows, dataSchema, dictionaryMap, fixedSizeDataBytes, variableSizeDataBytes);
        this._errCodeToExceptionMap = new HashMap<Integer, String>();
    }

    public DataTableImplV3() {
        this._errCodeToExceptionMap = new HashMap<Integer, String>();
    }

    public DataTableImplV3(ByteBuffer byteBuffer) throws IOException {
        this._numRows = byteBuffer.getInt();
        this._numColumns = byteBuffer.getInt();
        int exceptionsStart = byteBuffer.getInt();
        int exceptionsLength = byteBuffer.getInt();
        int dictionaryMapStart = byteBuffer.getInt();
        int dictionaryMapLength = byteBuffer.getInt();
        int dataSchemaStart = byteBuffer.getInt();
        int dataSchemaLength = byteBuffer.getInt();
        int fixedSizeDataStart = byteBuffer.getInt();
        int fixedSizeDataLength = byteBuffer.getInt();
        int variableSizeDataStart = byteBuffer.getInt();
        int variableSizeDataLength = byteBuffer.getInt();
        if (exceptionsLength != 0) {
            byte[] exceptionsBytes = new byte[exceptionsLength];
            byteBuffer.position(exceptionsStart);
            byteBuffer.get(exceptionsBytes);
            this._errCodeToExceptionMap = this.deserializeExceptions(exceptionsBytes);
        } else {
            this._errCodeToExceptionMap = new HashMap<Integer, String>();
        }
        if (dictionaryMapLength != 0) {
            byte[] dictionaryMapBytes = new byte[dictionaryMapLength];
            byteBuffer.position(dictionaryMapStart);
            byteBuffer.get(dictionaryMapBytes);
            this._dictionaryMap = this.deserializeDictionaryMap(dictionaryMapBytes);
        } else {
            this._dictionaryMap = null;
        }
        if (dataSchemaLength != 0) {
            byte[] schemaBytes = new byte[dataSchemaLength];
            byteBuffer.position(dataSchemaStart);
            byteBuffer.get(schemaBytes);
            this._dataSchema = DataSchema.fromBytes((byte[])schemaBytes);
            this._columnOffsets = new int[this._dataSchema.size()];
            this._rowSizeInBytes = DataTableUtils.computeColumnOffsets(this._dataSchema, this._columnOffsets);
        } else {
            this._dataSchema = null;
            this._columnOffsets = null;
            this._rowSizeInBytes = 0;
        }
        if (fixedSizeDataLength != 0) {
            this._fixedSizeDataBytes = new byte[fixedSizeDataLength];
            byteBuffer.position(fixedSizeDataStart);
            byteBuffer.get(this._fixedSizeDataBytes);
            this._fixedSizeData = ByteBuffer.wrap(this._fixedSizeDataBytes);
        } else {
            this._fixedSizeDataBytes = null;
            this._fixedSizeData = null;
        }
        if (variableSizeDataLength != 0) {
            this._variableSizeDataBytes = new byte[variableSizeDataLength];
            byteBuffer.position(variableSizeDataStart);
            byteBuffer.get(this._variableSizeDataBytes);
            this._variableSizeData = ByteBuffer.wrap(this._variableSizeDataBytes);
        } else {
            this._variableSizeDataBytes = null;
            this._variableSizeData = null;
        }
        int metadataLength = byteBuffer.getInt();
        if (metadataLength != 0) {
            byte[] metadataBytes = new byte[metadataLength];
            byteBuffer.get(metadataBytes);
            this._metadata = this.deserializeMetadata(metadataBytes);
        }
    }

    public void addException(ProcessingException processingException) {
        this._errCodeToExceptionMap.put(processingException.getErrorCode(), processingException.getMessage());
    }

    public Map<Integer, String> getExceptions() {
        return this._errCodeToExceptionMap;
    }

    public byte[] toBytes() throws IOException {
        ThreadTimer threadTimer = new ThreadTimer();
        threadTimer.start();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(3);
        dataOutputStream.writeInt(this._numRows);
        dataOutputStream.writeInt(this._numColumns);
        int dataOffset = 52;
        dataOutputStream.writeInt(dataOffset);
        byte[] exceptionsBytes = this.serializeExceptions();
        dataOutputStream.writeInt(exceptionsBytes.length);
        dataOutputStream.writeInt(dataOffset += exceptionsBytes.length);
        byte[] dictionaryMapBytes = null;
        if (this._dictionaryMap != null) {
            dictionaryMapBytes = this.serializeDictionaryMap();
            dataOutputStream.writeInt(dictionaryMapBytes.length);
            dataOffset += dictionaryMapBytes.length;
        } else {
            dataOutputStream.writeInt(0);
        }
        dataOutputStream.writeInt(dataOffset);
        byte[] dataSchemaBytes = null;
        if (this._dataSchema != null) {
            dataSchemaBytes = this._dataSchema.toBytes();
            dataOutputStream.writeInt(dataSchemaBytes.length);
            dataOffset += dataSchemaBytes.length;
        } else {
            dataOutputStream.writeInt(0);
        }
        dataOutputStream.writeInt(dataOffset);
        if (this._fixedSizeDataBytes != null) {
            dataOutputStream.writeInt(this._fixedSizeDataBytes.length);
            dataOffset += this._fixedSizeDataBytes.length;
        } else {
            dataOutputStream.writeInt(0);
        }
        dataOutputStream.writeInt(dataOffset);
        if (this._variableSizeDataBytes != null) {
            dataOutputStream.writeInt(this._variableSizeDataBytes.length);
        } else {
            dataOutputStream.writeInt(0);
        }
        dataOutputStream.write(exceptionsBytes);
        if (dictionaryMapBytes != null) {
            dataOutputStream.write(dictionaryMapBytes);
        }
        if (dataSchemaBytes != null) {
            dataOutputStream.write(dataSchemaBytes);
        }
        if (this._fixedSizeDataBytes != null) {
            dataOutputStream.write(this._fixedSizeDataBytes);
        }
        if (this._variableSizeDataBytes != null) {
            dataOutputStream.write(this._variableSizeDataBytes);
        }
        long responseSerializationCpuTimeNs = threadTimer.stopAndGetThreadTimeNs();
        long threadCpuTimeNs = Long.parseLong(this.getMetadata().getOrDefault(DataTable.MetadataKey.THREAD_CPU_TIME_NS.getName(), "0")) + responseSerializationCpuTimeNs;
        this.getMetadata().put(DataTable.MetadataKey.THREAD_CPU_TIME_NS.getName(), String.valueOf(threadCpuTimeNs));
        byte[] metadataBytes = this.serializeMetadata();
        dataOutputStream.writeInt(metadataBytes.length);
        dataOutputStream.write(metadataBytes);
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] serializeMetadata() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(this._metadata.size());
        for (Map.Entry entry : this._metadata.entrySet()) {
            DataTable.MetadataKey key = DataTable.MetadataKey.getByName((String)((String)entry.getKey()));
            if (key == null) continue;
            String value = (String)entry.getValue();
            dataOutputStream.writeInt(key.ordinal());
            if (key.getValueType() == DataTable.MetadataValueType.INT) {
                dataOutputStream.write(Ints.toByteArray((int)Integer.parseInt(value)));
                continue;
            }
            if (key.getValueType() == DataTable.MetadataValueType.LONG) {
                dataOutputStream.write(Longs.toByteArray((long)Long.parseLong(value)));
                continue;
            }
            byte[] valueBytes = StringUtil.encodeUtf8((String)value);
            dataOutputStream.writeInt(valueBytes.length);
            dataOutputStream.write(valueBytes);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private Map<String, String> deserializeMetadata(byte[] bytes) throws IOException {
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);){
            HashMap<String, String> hashMap;
            try (DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);){
                int numEntries = dataInputStream.readInt();
                HashMap<String, String> metadata = new HashMap<String, String>();
                for (int i = 0; i < numEntries; ++i) {
                    String value;
                    int keyId = dataInputStream.readInt();
                    DataTable.MetadataKey key = DataTable.MetadataKey.getByOrdinal((int)keyId);
                    if (key == null) continue;
                    if (key.getValueType() == DataTable.MetadataValueType.INT) {
                        value = String.valueOf(DataTableUtils.decodeInt(dataInputStream));
                        metadata.put(key.getName(), value);
                        continue;
                    }
                    if (key.getValueType() == DataTable.MetadataValueType.LONG) {
                        value = String.valueOf(DataTableUtils.decodeLong(dataInputStream));
                        metadata.put(key.getName(), value);
                        continue;
                    }
                    value = String.valueOf(DataTableUtils.decodeString(dataInputStream));
                    metadata.put(key.getName(), value);
                }
                hashMap = metadata;
            }
            return hashMap;
        }
    }

    private byte[] serializeExceptions() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(this._errCodeToExceptionMap.size());
        for (Map.Entry<Integer, String> entry : this._errCodeToExceptionMap.entrySet()) {
            int key = entry.getKey();
            String value = entry.getValue();
            byte[] valueBytes = StringUtil.encodeUtf8((String)value);
            dataOutputStream.writeInt(key);
            dataOutputStream.writeInt(valueBytes.length);
            dataOutputStream.write(valueBytes);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private Map<Integer, String> deserializeExceptions(byte[] bytes) throws IOException {
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);){
            HashMap<Integer, String> hashMap;
            try (DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);){
                int numExceptions = dataInputStream.readInt();
                HashMap<Integer, String> exceptions = new HashMap<Integer, String>(numExceptions);
                for (int i = 0; i < numExceptions; ++i) {
                    int errCode = dataInputStream.readInt();
                    String errMessage = DataTableUtils.decodeString(dataInputStream);
                    exceptions.put(errCode, errMessage);
                }
                hashMap = exceptions;
            }
            return hashMap;
        }
    }
}

