/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.common.datatable;

import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.DataTable;
import org.apache.pinot.common.utils.StringUtil;
import org.apache.pinot.core.common.datatable.DataTableBuilder;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctAggregationFunction;
import org.apache.pinot.core.query.distinct.DistinctTable;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.request.context.utils.QueryContextUtils;
import org.apache.pinot.core.util.QueryOptions;

public class DataTableUtils {
    private DataTableUtils() {
    }

    public static int computeColumnOffsets(DataSchema dataSchema, int[] columnOffsets) {
        int numColumns = columnOffsets.length;
        assert (numColumns == dataSchema.size());
        DataSchema.ColumnDataType[] storedColumnDataTypes = dataSchema.getStoredColumnDataTypes();
        int rowSizeInBytes = 0;
        block7: for (int i = 0; i < numColumns; ++i) {
            columnOffsets[i] = rowSizeInBytes;
            switch (storedColumnDataTypes[i]) {
                case INT: {
                    rowSizeInBytes += 4;
                    continue block7;
                }
                case LONG: {
                    rowSizeInBytes += 8;
                    continue block7;
                }
                case FLOAT: {
                    rowSizeInBytes += 8;
                    continue block7;
                }
                case DOUBLE: {
                    rowSizeInBytes += 8;
                    continue block7;
                }
                case STRING: {
                    rowSizeInBytes += 4;
                    continue block7;
                }
                default: {
                    rowSizeInBytes += 8;
                }
            }
        }
        return rowSizeInBytes;
    }

    public static DataTable buildEmptyDataTable(QueryContext queryContext) throws IOException {
        if (QueryContextUtils.isSelectionQuery(queryContext)) {
            return DataTableUtils.buildEmptyDataTableForSelectionQuery(queryContext);
        }
        if (QueryContextUtils.isAggregationQuery(queryContext)) {
            return DataTableUtils.buildEmptyDataTableForAggregationQuery(queryContext);
        }
        assert (QueryContextUtils.isDistinctQuery(queryContext));
        return DataTableUtils.buildEmptyDataTableForDistinctQuery(queryContext);
    }

    private static DataTable buildEmptyDataTableForSelectionQuery(QueryContext queryContext) {
        List<ExpressionContext> selectExpressions = queryContext.getSelectExpressions();
        int numSelectExpressions = selectExpressions.size();
        String[] columnNames = new String[numSelectExpressions];
        for (int i = 0; i < numSelectExpressions; ++i) {
            columnNames[i] = selectExpressions.get(i).toString();
        }
        Object[] columnDataTypes = new DataSchema.ColumnDataType[numSelectExpressions];
        Arrays.fill(columnDataTypes, DataSchema.ColumnDataType.STRING);
        DataSchema dataSchema = new DataSchema(columnNames, (DataSchema.ColumnDataType[])columnDataTypes);
        return new DataTableBuilder(dataSchema).build();
    }

    private static DataTable buildEmptyDataTableForAggregationQuery(QueryContext queryContext) throws IOException {
        AggregationFunction[] aggregationFunctions = queryContext.getAggregationFunctions();
        assert (aggregationFunctions != null);
        int numAggregations = aggregationFunctions.length;
        List<ExpressionContext> groupByExpressions = queryContext.getGroupByExpressions();
        if (groupByExpressions != null) {
            if (new QueryOptions(queryContext.getQueryOptions()).isGroupByModeSQL()) {
                int numColumns = groupByExpressions.size() + numAggregations;
                String[] columnNames = new String[numColumns];
                DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[numColumns];
                int index = 0;
                for (ExpressionContext groupByExpression : groupByExpressions) {
                    columnNames[index] = groupByExpression.toString();
                    columnDataTypes[index] = DataSchema.ColumnDataType.STRING;
                    ++index;
                }
                for (AggregationFunction aggregationFunction : aggregationFunctions) {
                    columnNames[index] = aggregationFunction.getResultColumnName();
                    columnDataTypes[index] = aggregationFunction.getIntermediateResultColumnType();
                    ++index;
                }
                return new DataTableBuilder(new DataSchema(columnNames, columnDataTypes)).build();
            }
            String[] columnNames = new String[]{"functionName", "GroupByResultMap"};
            DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[]{DataSchema.ColumnDataType.STRING, DataSchema.ColumnDataType.OBJECT};
            DataTableBuilder dataTableBuilder = new DataTableBuilder(new DataSchema(columnNames, columnDataTypes));
            for (AggregationFunction aggregationFunction : aggregationFunctions) {
                dataTableBuilder.startRow();
                dataTableBuilder.setColumn(0, aggregationFunction.getColumnName());
                dataTableBuilder.setColumn(1, Collections.emptyMap());
                dataTableBuilder.finishRow();
            }
            return dataTableBuilder.build();
        }
        String[] aggregationColumnNames = new String[numAggregations];
        DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[numAggregations];
        Object[] aggregationResults = new Object[numAggregations];
        for (int i = 0; i < numAggregations; ++i) {
            AggregationFunction aggregationFunction = aggregationFunctions[i];
            aggregationColumnNames[i] = aggregationFunction.getColumnName();
            columnDataTypes[i] = aggregationFunction.getIntermediateResultColumnType();
            aggregationResults[i] = aggregationFunction.extractAggregationResult(aggregationFunction.createAggregationResultHolder());
        }
        DataTableBuilder dataTableBuilder = new DataTableBuilder(new DataSchema(aggregationColumnNames, columnDataTypes));
        dataTableBuilder.startRow();
        block9: for (int i = 0; i < numAggregations; ++i) {
            switch (columnDataTypes[i]) {
                case LONG: {
                    dataTableBuilder.setColumn(i, ((Number)aggregationResults[i]).longValue());
                    continue block9;
                }
                case DOUBLE: {
                    dataTableBuilder.setColumn(i, (Double)aggregationResults[i]);
                    continue block9;
                }
                case OBJECT: {
                    dataTableBuilder.setColumn(i, aggregationResults[i]);
                    continue block9;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported aggregation column data type: " + columnDataTypes[i] + " for column: " + aggregationColumnNames[i]);
                }
            }
        }
        dataTableBuilder.finishRow();
        return dataTableBuilder.build();
    }

    private static DataTable buildEmptyDataTableForDistinctQuery(QueryContext queryContext) throws IOException {
        AggregationFunction[] aggregationFunctions = queryContext.getAggregationFunctions();
        assert (aggregationFunctions != null && aggregationFunctions.length == 1 && aggregationFunctions[0] instanceof DistinctAggregationFunction);
        DistinctAggregationFunction distinctAggregationFunction = (DistinctAggregationFunction)aggregationFunctions[0];
        String[] columnNames = distinctAggregationFunction.getColumns();
        Object[] columnDataTypes = new DataSchema.ColumnDataType[columnNames.length];
        Arrays.fill(columnDataTypes, DataSchema.ColumnDataType.STRING);
        DistinctTable distinctTable = new DistinctTable(new DataSchema(columnNames, (DataSchema.ColumnDataType[])columnDataTypes), Collections.emptySet());
        DataTableBuilder dataTableBuilder = new DataTableBuilder(new DataSchema(new String[]{distinctAggregationFunction.getColumnName()}, new DataSchema.ColumnDataType[]{DataSchema.ColumnDataType.OBJECT}));
        dataTableBuilder.startRow();
        dataTableBuilder.setColumn(0, distinctTable);
        dataTableBuilder.finishRow();
        return dataTableBuilder.build();
    }

    public static String decodeString(DataInputStream dataInputStream) throws IOException {
        int length = dataInputStream.readInt();
        if (length == 0) {
            return "";
        }
        byte[] buffer = new byte[length];
        int numBytesRead = dataInputStream.read(buffer);
        assert (numBytesRead == length);
        return StringUtil.decodeUtf8((byte[])buffer);
    }

    public static int decodeInt(DataInputStream dataInputStream) throws IOException {
        int length = 4;
        byte[] buffer = new byte[length];
        int numBytesRead = dataInputStream.read(buffer);
        assert (numBytesRead == length);
        return Ints.fromByteArray((byte[])buffer);
    }

    public static long decodeLong(DataInputStream dataInputStream) throws IOException {
        int length = 8;
        byte[] buffer = new byte[length];
        int numBytesRead = dataInputStream.read(buffer);
        assert (numBytesRead == length);
        return Longs.fromByteArray((byte[])buffer);
    }
}

