/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.manager;

import com.google.common.base.Preconditions;
import com.google.common.cache.LoadingCache;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.helix.HelixManager;
import org.apache.helix.ZNRecord;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ServerGauge;
import org.apache.pinot.common.metrics.ServerMeter;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.restlet.resources.SegmentErrorInfo;
import org.apache.pinot.core.data.manager.offline.ImmutableSegmentDataManager;
import org.apache.pinot.segment.local.data.manager.SegmentDataManager;
import org.apache.pinot.segment.local.data.manager.TableDataManager;
import org.apache.pinot.segment.local.data.manager.TableDataManagerConfig;
import org.apache.pinot.segment.local.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.segment.spi.ImmutableSegment;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class BaseTableDataManager
implements TableDataManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseTableDataManager.class);
    protected final ConcurrentHashMap<String, SegmentDataManager> _segmentDataManagerMap = new ConcurrentHashMap();
    protected TableDataManagerConfig _tableDataManagerConfig;
    protected String _instanceId;
    protected ZkHelixPropertyStore<ZNRecord> _propertyStore;
    protected ServerMetrics _serverMetrics;
    protected String _tableNameWithType;
    protected String _tableDataDir;
    protected File _indexDir;
    protected Logger _logger;
    protected HelixManager _helixManager;
    protected String _authToken;
    protected LoadingCache<Pair<String, String>, SegmentErrorInfo> _errorCache;

    public void init(TableDataManagerConfig tableDataManagerConfig, String instanceId, ZkHelixPropertyStore<ZNRecord> propertyStore, ServerMetrics serverMetrics, HelixManager helixManager, @Nullable LoadingCache<Pair<String, String>, SegmentErrorInfo> errorCache) {
        LOGGER.info("Initializing table data manager for table: {}", (Object)tableDataManagerConfig.getTableName());
        this._tableDataManagerConfig = tableDataManagerConfig;
        this._instanceId = instanceId;
        this._propertyStore = propertyStore;
        this._serverMetrics = serverMetrics;
        this._helixManager = helixManager;
        this._authToken = tableDataManagerConfig.getAuthToken();
        this._tableNameWithType = tableDataManagerConfig.getTableName();
        this._tableDataDir = tableDataManagerConfig.getDataDir();
        this._indexDir = new File(this._tableDataDir);
        if (!this._indexDir.exists()) {
            Preconditions.checkState((boolean)this._indexDir.mkdirs());
        }
        this._errorCache = errorCache;
        this._logger = LoggerFactory.getLogger((String)(this._tableNameWithType + "-" + this.getClass().getSimpleName()));
        this.doInit();
        this._logger.info("Initialized table data manager for table: {} with data directory: {}", (Object)this._tableNameWithType, (Object)this._tableDataDir);
    }

    protected abstract void doInit();

    public void start() {
        this._logger.info("Starting table data manager for table: {}", (Object)this._tableNameWithType);
        this.doStart();
        this._logger.info("Started table data manager for table: {}", (Object)this._tableNameWithType);
    }

    protected abstract void doStart();

    public void shutDown() {
        this._logger.info("Shutting down table data manager for table: {}", (Object)this._tableNameWithType);
        this.doShutdown();
        this._logger.info("Shut down table data manager for table: {}", (Object)this._tableNameWithType);
    }

    protected abstract void doShutdown();

    public void addSegment(ImmutableSegment immutableSegment) {
        String segmentName = immutableSegment.getSegmentName();
        this._logger.info("Adding immutable segment: {} to table: {}", (Object)segmentName, (Object)this._tableNameWithType);
        this._serverMetrics.addValueToTableGauge(this._tableNameWithType, (AbstractMetrics.Gauge)ServerGauge.DOCUMENT_COUNT, (long)immutableSegment.getSegmentMetadata().getTotalDocs());
        this._serverMetrics.addValueToTableGauge(this._tableNameWithType, (AbstractMetrics.Gauge)ServerGauge.SEGMENT_COUNT, 1L);
        ImmutableSegmentDataManager newSegmentManager = new ImmutableSegmentDataManager(immutableSegment);
        SegmentDataManager oldSegmentManager = this._segmentDataManagerMap.put(segmentName, newSegmentManager);
        if (oldSegmentManager == null) {
            this._logger.info("Added new immutable segment: {} to table: {}", (Object)segmentName, (Object)this._tableNameWithType);
        } else {
            this._logger.info("Replaced immutable segment: {} of table: {}", (Object)segmentName, (Object)this._tableNameWithType);
            this.releaseSegment(oldSegmentManager);
        }
    }

    public void addSegment(File indexDir, IndexLoadingConfig indexLoadingConfig) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void addSegment(String segmentName, TableConfig tableConfig, IndexLoadingConfig indexLoadingConfig) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void removeSegment(String segmentName) {
        this._logger.info("Removing segment: {} from table: {}", (Object)segmentName, (Object)this._tableNameWithType);
        SegmentDataManager segmentDataManager = this._segmentDataManagerMap.remove(segmentName);
        if (segmentDataManager != null) {
            this.releaseSegment(segmentDataManager);
            this._logger.info("Removed segment: {} from table: {}", (Object)segmentName, (Object)this._tableNameWithType);
        } else {
            this._logger.info("Failed to find segment: {} in table: {}", (Object)segmentName, (Object)this._tableNameWithType);
        }
    }

    public List<SegmentDataManager> acquireAllSegments() {
        ArrayList<SegmentDataManager> segmentDataManagers = new ArrayList<SegmentDataManager>();
        for (SegmentDataManager segmentDataManager : this._segmentDataManagerMap.values()) {
            if (!segmentDataManager.increaseReferenceCount()) continue;
            segmentDataManagers.add(segmentDataManager);
        }
        return segmentDataManagers;
    }

    public List<SegmentDataManager> acquireSegments(List<String> segmentNames) {
        ArrayList<SegmentDataManager> segmentDataManagers = new ArrayList<SegmentDataManager>();
        for (String segmentName : segmentNames) {
            SegmentDataManager segmentDataManager = this._segmentDataManagerMap.get(segmentName);
            if (segmentDataManager == null || !segmentDataManager.increaseReferenceCount()) continue;
            segmentDataManagers.add(segmentDataManager);
        }
        return segmentDataManagers;
    }

    @Nullable
    public SegmentDataManager acquireSegment(String segmentName) {
        SegmentDataManager segmentDataManager = this._segmentDataManagerMap.get(segmentName);
        if (segmentDataManager != null && segmentDataManager.increaseReferenceCount()) {
            return segmentDataManager;
        }
        return null;
    }

    public void releaseSegment(SegmentDataManager segmentDataManager) {
        if (segmentDataManager.decreaseReferenceCount()) {
            this.closeSegment(segmentDataManager);
        }
    }

    private void closeSegment(SegmentDataManager segmentDataManager) {
        String segmentName = segmentDataManager.getSegmentName();
        this._logger.info("Closing segment: {} of table: {}", (Object)segmentName, (Object)this._tableNameWithType);
        this._serverMetrics.addValueToTableGauge(this._tableNameWithType, (AbstractMetrics.Gauge)ServerGauge.SEGMENT_COUNT, -1L);
        this._serverMetrics.addMeteredTableValue(this._tableNameWithType, (AbstractMetrics.Meter)ServerMeter.DELETED_SEGMENT_COUNT, 1L);
        this._serverMetrics.addValueToTableGauge(this._tableNameWithType, (AbstractMetrics.Gauge)ServerGauge.DOCUMENT_COUNT, (long)(-segmentDataManager.getSegment().getSegmentMetadata().getTotalDocs()));
        segmentDataManager.destroy();
        this._logger.info("Closed segment: {} of table: {}", (Object)segmentName, (Object)this._tableNameWithType);
    }

    public int getNumSegments() {
        return this._segmentDataManagerMap.size();
    }

    public String getTableName() {
        return this._tableNameWithType;
    }

    public File getTableDataDir() {
        return this._indexDir;
    }

    public void addSegmentError(String segmentName, SegmentErrorInfo segmentErrorInfo) {
        this._errorCache.put((Object)new Pair((Serializable)((Object)this._tableNameWithType), (Serializable)((Object)segmentName)), (Object)segmentErrorInfo);
    }

    public Map<String, SegmentErrorInfo> getSegmentErrors() {
        if (this._errorCache == null) {
            return Collections.emptyMap();
        }
        return this._errorCache.asMap().entrySet().stream().filter(map -> ((String)((Object)((Pair)map.getKey()).getFirst())).equals(this._tableNameWithType)).collect(Collectors.toMap(map -> (String)((Object)((Pair)map.getKey()).getSecond()), Map.Entry::getValue));
    }
}

