/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.manager.realtime;

import java.io.File;
import org.apache.pinot.common.protocols.SegmentCompletionProtocol;
import org.apache.pinot.core.data.manager.realtime.LLRealtimeSegmentDataManager;
import org.apache.pinot.core.data.manager.realtime.SegmentCommitter;
import org.apache.pinot.server.realtime.ServerSegmentCompletionProtocolHandler;
import org.slf4j.Logger;

public class DefaultSegmentCommitter
implements SegmentCommitter {
    private final SegmentCompletionProtocol.Request.Params _params;
    private final ServerSegmentCompletionProtocolHandler _protocolHandler;
    private final Logger _segmentLogger;

    public DefaultSegmentCommitter(Logger segmentLogger, ServerSegmentCompletionProtocolHandler protocolHandler, SegmentCompletionProtocol.Request.Params params) {
        this._segmentLogger = segmentLogger;
        this._protocolHandler = protocolHandler;
        this._params = params;
    }

    @Override
    public SegmentCompletionProtocol.Response commit(LLRealtimeSegmentDataManager.SegmentBuildDescriptor segmentBuildDescriptor) {
        File segmentTarFile = segmentBuildDescriptor.getSegmentTarFile();
        SegmentCompletionProtocol.Response response = this._protocolHandler.segmentCommit(this._params, segmentTarFile);
        if (!response.getStatus().equals((Object)SegmentCompletionProtocol.ControllerResponseStatus.COMMIT_SUCCESS)) {
            this._segmentLogger.warn("Commit failed  with response {}", (Object)response.toJsonString());
        }
        return response;
    }
}

