/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.manager.realtime;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.protocols.SegmentCompletionProtocol;
import org.apache.pinot.common.utils.FileUploadDownloadClient;
import org.apache.pinot.common.utils.LLCSegmentName;
import org.apache.pinot.core.data.manager.realtime.SegmentUploader;
import org.apache.pinot.core.util.SegmentCompletionProtocolUtils;
import org.apache.pinot.server.realtime.ControllerLeaderLocator;
import org.slf4j.Logger;

public class Server2ControllerSegmentUploader
implements SegmentUploader {
    private final Logger _segmentLogger;
    private final URI _controllerSegmentUploadCommitUrl;
    private final FileUploadDownloadClient _fileUploadDownloadClient;
    private final String _segmentName;
    private final int _segmentUploadRequestTimeoutMs;
    private final ServerMetrics _serverMetrics;
    private final String _authToken;

    public Server2ControllerSegmentUploader(Logger segmentLogger, FileUploadDownloadClient fileUploadDownloadClient, String controllerSegmentUploadCommitUrl, String segmentName, int segmentUploadRequestTimeoutMs, ServerMetrics serverMetrics, String authToken) throws URISyntaxException {
        this._segmentLogger = segmentLogger;
        this._fileUploadDownloadClient = fileUploadDownloadClient;
        this._controllerSegmentUploadCommitUrl = new URI(controllerSegmentUploadCommitUrl);
        this._segmentName = segmentName;
        this._segmentUploadRequestTimeoutMs = segmentUploadRequestTimeoutMs;
        this._serverMetrics = serverMetrics;
        this._authToken = authToken;
    }

    @Override
    public URI uploadSegment(File segmentFile, LLCSegmentName segmentName) {
        SegmentCompletionProtocol.Response response = this.uploadSegmentToController(segmentFile);
        if (response.getStatus() == SegmentCompletionProtocol.ControllerResponseStatus.UPLOAD_SUCCESS) {
            try {
                return new URI(response.getSegmentLocation());
            }
            catch (URISyntaxException e) {
                this._segmentLogger.error("Error in segment location format: ", (Throwable)e);
            }
        }
        return null;
    }

    public SegmentCompletionProtocol.Response uploadSegmentToController(File segmentFile) {
        SegmentCompletionProtocol.Response response;
        try {
            String responseStr = this._fileUploadDownloadClient.uploadSegment(this._controllerSegmentUploadCommitUrl, this._segmentName, segmentFile, FileUploadDownloadClient.makeAuthHeader((String)this._authToken), null, this._segmentUploadRequestTimeoutMs).getResponse();
            response = SegmentCompletionProtocol.Response.fromJsonString((String)responseStr);
            this._segmentLogger.info("Controller response {} for {}", (Object)response.toJsonString(), (Object)this._controllerSegmentUploadCommitUrl);
            if (response.getStatus().equals((Object)SegmentCompletionProtocol.ControllerResponseStatus.NOT_LEADER)) {
                ControllerLeaderLocator.getInstance().invalidateCachedControllerLeader();
            }
        }
        catch (Exception e) {
            response = SegmentCompletionProtocol.RESP_NOT_SENT;
            this._segmentLogger.error("Could not send request {}", (Object)this._controllerSegmentUploadCommitUrl, (Object)e);
            ControllerLeaderLocator.getInstance().invalidateCachedControllerLeader();
        }
        SegmentCompletionProtocolUtils.raiseSegmentCompletionProtocolResponseMetric(this._serverMetrics, response);
        return response;
    }
}

