/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.table;

import java.util.Arrays;
import java.util.List;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.data.table.BaseTable;
import org.apache.pinot.core.data.table.Key;
import org.apache.pinot.core.data.table.Record;
import org.apache.pinot.core.data.table.TableResizer;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.request.context.QueryContext;

public abstract class IndexedTable
extends BaseTable {
    protected final int _numKeyColumns;
    protected final AggregationFunction[] _aggregationFunctions;
    protected final boolean _hasOrderBy;
    protected final TableResizer _tableResizer;
    protected List<Record> _sortedRecords;
    protected final int _trimSize;
    protected final int _trimThreshold;

    protected IndexedTable(DataSchema dataSchema, QueryContext queryContext, int trimSize, int trimThreshold) {
        super(dataSchema);
        List<ExpressionContext> groupByExpressions = queryContext.getGroupByExpressions();
        assert (groupByExpressions != null);
        this._numKeyColumns = groupByExpressions.size();
        this._aggregationFunctions = queryContext.getAggregationFunctions();
        List<OrderByExpressionContext> orderByExpressions = queryContext.getOrderByExpressions();
        if (orderByExpressions != null) {
            this._hasOrderBy = true;
            this._tableResizer = new TableResizer(dataSchema, queryContext);
            this._trimSize = Math.min(trimSize, trimThreshold / 2);
            this._trimThreshold = trimThreshold;
        } else {
            this._hasOrderBy = false;
            this._tableResizer = null;
            this._trimSize = trimSize;
            this._trimThreshold = trimSize;
        }
    }

    @Override
    public boolean upsert(Record record) {
        Object[] keyValues = Arrays.copyOf(record.getValues(), this._numKeyColumns);
        return this.upsert(new Key(keyValues), record);
    }

    public abstract int getNumResizes();

    public abstract long getResizeTimeMs();
}

