/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.table;

import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.data.table.ConcurrentIndexedTable;
import org.apache.pinot.core.data.table.Key;
import org.apache.pinot.core.data.table.Record;
import org.apache.pinot.core.query.request.context.QueryContext;

public class UnboundedConcurrentIndexedTable
extends ConcurrentIndexedTable {
    public UnboundedConcurrentIndexedTable(DataSchema dataSchema, QueryContext queryContext, int trimSize, int trimThreshold) {
        super(dataSchema, queryContext, trimSize, trimThreshold);
    }

    @Override
    public boolean upsert(Key key, Record newRecord) {
        if (this._noMoreNewRecords.get()) {
            this._lookupMap.computeIfPresent(key, (k, v) -> {
                Object[] existingValues = v.getValues();
                Object[] newValues = newRecord.getValues();
                int aggNum = 0;
                for (int i = this._numKeyColumns; i < this._numColumns; ++i) {
                    existingValues[i] = this._aggregationFunctions[aggNum++].merge(existingValues[i], newValues[i]);
                }
                return v;
            });
        } else {
            this._lookupMap.compute(key, (k, v) -> {
                if (v == null) {
                    return newRecord;
                }
                Object[] existingValues = v.getValues();
                Object[] newValues = newRecord.getValues();
                int aggNum = 0;
                for (int i = this._numKeyColumns; i < this._numColumns; ++i) {
                    existingValues[i] = this._aggregationFunctions[aggNum++].merge(existingValues[i], newValues[i]);
                }
                return v;
            });
            if (this._lookupMap.size() >= this._trimSize && !this._hasOrderBy) {
                this._noMoreNewRecords.set(true);
            }
        }
        return true;
    }
}

