/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.geospatial.transform.function;

import org.apache.pinot.segment.local.utils.GeometrySerializer;
import org.apache.pinot.segment.local.utils.GeometryUtils;
import org.apache.pinot.spi.annotations.ScalarFunction;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.io.WKTWriter;

public class ScalarFunctions {
    @ScalarFunction
    public static byte[] stPoint(double x, double y) {
        return GeometrySerializer.serialize((Geometry)GeometryUtils.GEOMETRY_FACTORY.createPoint(new Coordinate(x, y)));
    }

    @ScalarFunction
    public static byte[] stPoint(double x, double y, boolean isGeography) {
        Point point = GeometryUtils.GEOMETRY_FACTORY.createPoint(new Coordinate(x, y));
        if (isGeography) {
            GeometryUtils.setGeography((Geometry)point);
        }
        return GeometrySerializer.serialize((Geometry)point);
    }

    @ScalarFunction
    public static String stAsText(byte[] bytes) {
        WKTWriter writer = new WKTWriter();
        return writer.write(GeometrySerializer.deserialize((byte[])bytes));
    }

    @ScalarFunction
    public static byte[] toSphericalGeography(byte[] bytes) {
        Geometry geometry = GeometrySerializer.deserialize((byte[])bytes);
        GeometryUtils.setGeography((Geometry)geometry);
        return GeometrySerializer.serialize((Geometry)geometry);
    }

    @ScalarFunction
    public static byte[] toGeometry(byte[] bytes) {
        Geometry geometry = GeometrySerializer.deserialize((byte[])bytes);
        GeometryUtils.setGeometry((Geometry)geometry);
        return GeometrySerializer.serialize((Geometry)geometry);
    }
}

