/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.geospatial.transform.function;

import com.google.common.base.Preconditions;
import org.apache.pinot.core.geospatial.transform.function.ConstructFromTextFunction;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.plan.DocIdSetPlanNode;
import org.apache.pinot.segment.local.utils.GeometrySerializer;
import org.apache.pinot.segment.local.utils.GeometryUtils;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.ParseException;

public class StPolygonFunction
extends ConstructFromTextFunction {
    public static final String FUNCTION_NAME = "ST_Polygon";

    @Override
    protected GeometryFactory getGeometryFactory() {
        return GeometryUtils.GEOMETRY_FACTORY;
    }

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public byte[][] transformToBytesValuesSV(ProjectionBlock projectionBlock) {
        if (this._results == null) {
            this._results = new byte[DocIdSetPlanNode.MAX_DOC_PER_CALL][];
        }
        String[] argumentValues = this._transformFunction.transformToStringValuesSV(projectionBlock);
        int length = projectionBlock.getNumDocs();
        for (int i = 0; i < length; ++i) {
            try {
                Geometry geometry = this._reader.read(argumentValues[i]);
                Preconditions.checkArgument((boolean)(geometry instanceof Polygon), (Object)"The geometry object must be polygon");
                this._results[i] = GeometrySerializer.serialize((Geometry)geometry);
                continue;
            }
            catch (ParseException e) {
                new RuntimeException(String.format("Failed to parse geometry from string: %s", argumentValues[i]));
            }
        }
        return this._results;
    }
}

