/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.minion;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.pinot.core.minion.segment.DefaultRecordPartitioner;
import org.apache.pinot.core.minion.segment.MapperRecordReader;
import org.apache.pinot.core.minion.segment.RecordAggregator;
import org.apache.pinot.core.minion.segment.RecordPartitioner;
import org.apache.pinot.core.minion.segment.ReducerRecordReader;
import org.apache.pinot.core.segment.processing.transformer.RecordTransformer;
import org.apache.pinot.segment.local.segment.creator.impl.SegmentIndexCreationDriverImpl;
import org.apache.pinot.segment.local.segment.readers.PinotSegmentRecordReader;
import org.apache.pinot.segment.spi.creator.SegmentGeneratorConfig;
import org.apache.pinot.segment.spi.index.metadata.SegmentMetadataImpl;
import org.apache.pinot.spi.config.table.IndexingConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.RecordReader;

public class SegmentConverter {
    private static final int DEFAULT_NUM_PARTITION = 1;
    private static final String MAPPER_PREFIX = "mapper_";
    private static final String REDUCER_PREFIX = "reducer_";
    private static final String INDEX_PREFIX = "index_";
    private List<File> _inputIndexDirs;
    private File _workingDir;
    private String _tableName;
    private String _segmentName;
    private RecordTransformer _recordTransformer;
    private TableConfig _tableConfig;
    private int _totalNumPartition;
    private RecordPartitioner _recordPartitioner;
    private RecordAggregator _recordAggregator;
    private List<String> _groupByColumns;
    private boolean _skipTimeValueCheck;
    private Schema _schema;

    public SegmentConverter(List<File> inputIndexDirs, File workingDir, String tableName, String segmentName, int totalNumPartition, RecordTransformer recordTransformer, @Nullable RecordPartitioner recordPartitioner, @Nullable RecordAggregator recordAggregator, @Nullable List<String> groupByColumns, TableConfig tableConfig, boolean skipTimeValueCheck) {
        this._inputIndexDirs = inputIndexDirs;
        this._workingDir = workingDir;
        this._recordTransformer = recordTransformer;
        this._tableName = tableName;
        this._segmentName = segmentName;
        this._tableConfig = tableConfig;
        this._recordPartitioner = recordPartitioner == null ? new DefaultRecordPartitioner() : recordPartitioner;
        this._totalNumPartition = totalNumPartition < 1 ? 1 : totalNumPartition;
        this._recordAggregator = recordAggregator;
        this._groupByColumns = groupByColumns;
        this._skipTimeValueCheck = skipTimeValueCheck;
        for (File indexDir : inputIndexDirs) {
            Schema schema;
            try {
                schema = new SegmentMetadataImpl(indexDir).getSchema();
            }
            catch (IOException e) {
                throw new RuntimeException("Caught exception while reading schema from: " + indexDir);
            }
            if (this._schema == null) {
                this._schema = schema;
                continue;
            }
            Preconditions.checkState((boolean)this._schema.equals((Object)schema), (Object)"Schemas from input segments are not the same");
        }
    }

    public List<File> convertSegment() throws Exception {
        ArrayList<File> resultFiles = new ArrayList<File>();
        for (int currentPartition = 0; currentPartition < this._totalNumPartition; ++currentPartition) {
            Preconditions.checkNotNull((Object)this._recordTransformer);
            String mapperOutputPath = this._workingDir.getPath() + File.separator + MAPPER_PREFIX + currentPartition;
            String outputSegmentName = this._totalNumPartition <= 1 ? this._segmentName : this._segmentName + "_" + currentPartition;
            try (MapperRecordReader mapperRecordReader = new MapperRecordReader(this._inputIndexDirs, this._recordTransformer, this._recordPartitioner, this._totalNumPartition, currentPartition);){
                this.buildSegment(mapperOutputPath, outputSegmentName, mapperRecordReader);
            }
            File outputSegment = new File(mapperOutputPath + File.separator + outputSegmentName);
            if (this._recordAggregator != null && this._groupByColumns != null && this._groupByColumns.size() > 0) {
                String reducerOutputPath = this._workingDir.getPath() + File.separator + REDUCER_PREFIX + currentPartition;
                try (ReducerRecordReader reducerRecordReader = new ReducerRecordReader(outputSegment, this._recordAggregator, this._groupByColumns);){
                    this.buildSegment(reducerOutputPath, outputSegmentName, reducerRecordReader);
                }
                outputSegment = new File(reducerOutputPath + File.separator + outputSegmentName);
            }
            IndexingConfig indexingConfig = this._tableConfig.getIndexingConfig();
            List sortedColumn = indexingConfig.getSortedColumn();
            List invertedIndexColumns = indexingConfig.getInvertedIndexColumns();
            if (CollectionUtils.isNotEmpty((Collection)sortedColumn) || CollectionUtils.isNotEmpty((Collection)invertedIndexColumns)) {
                String indexGenerationOutputPath = this._workingDir.getPath() + File.separator + INDEX_PREFIX + currentPartition;
                try (PinotSegmentRecordReader pinotSegmentRecordReader = new PinotSegmentRecordReader(outputSegment, null, sortedColumn);){
                    this.buildSegment(indexGenerationOutputPath, outputSegmentName, (RecordReader)pinotSegmentRecordReader);
                }
                outputSegment = new File(indexGenerationOutputPath + File.separator + outputSegmentName);
            }
            resultFiles.add(outputSegment);
        }
        return resultFiles;
    }

    private void buildSegment(String outputPath, String segmentName, RecordReader recordReader) throws Exception {
        SegmentGeneratorConfig segmentGeneratorConfig = new SegmentGeneratorConfig(this._tableConfig, this._schema);
        segmentGeneratorConfig.setOutDir(outputPath);
        segmentGeneratorConfig.setSegmentName(segmentName);
        segmentGeneratorConfig.setSkipTimeValueCheck(this._skipTimeValueCheck);
        SegmentIndexCreationDriverImpl driver = new SegmentIndexCreationDriverImpl();
        driver.init(segmentGeneratorConfig, recordReader);
        driver.build();
    }

    public static class Builder {
        private List<File> _inputIndexDirs;
        private File _workingDir;
        private String _tableName;
        private String _segmentName;
        private RecordTransformer _recordTransformer;
        private TableConfig _tableConfig;
        private int _totalNumPartition;
        private RecordPartitioner _recordPartitioner;
        private RecordAggregator _recordAggregator;
        private List<String> _groupByColumns;
        private boolean _skipTimeValueCheck;

        public Builder setInputIndexDirs(List<File> inputIndexDirs) {
            this._inputIndexDirs = inputIndexDirs;
            return this;
        }

        public Builder setWorkingDir(File workingDir) {
            this._workingDir = workingDir;
            return this;
        }

        public Builder setTableName(String tableName) {
            this._tableName = tableName;
            return this;
        }

        public Builder setSegmentName(String segmentName) {
            this._segmentName = segmentName;
            return this;
        }

        public Builder setRecordTransformer(RecordTransformer recordTransformer) {
            this._recordTransformer = recordTransformer;
            return this;
        }

        public Builder setRecordPartitioner(RecordPartitioner recordPartitioner) {
            this._recordPartitioner = recordPartitioner;
            return this;
        }

        public Builder setRecordAggregator(RecordAggregator recordAggregator) {
            this._recordAggregator = recordAggregator;
            return this;
        }

        public Builder setTotalNumPartition(int totalNumPartition) {
            this._totalNumPartition = totalNumPartition;
            return this;
        }

        public Builder setGroupByColumns(List<String> groupByColumns) {
            this._groupByColumns = groupByColumns;
            return this;
        }

        public Builder setTableConfig(TableConfig tableConfig) {
            this._tableConfig = tableConfig;
            return this;
        }

        public Builder setSkipTimeValueCheck(boolean skipTimeValueCheck) {
            this._skipTimeValueCheck = skipTimeValueCheck;
            return this;
        }

        public SegmentConverter build() {
            if (this._groupByColumns != null && this._groupByColumns.size() > 0) {
                Preconditions.checkNotNull((Object)this._recordAggregator, (Object)"If group-by columns are given, the record aggregator is required.");
            } else {
                Preconditions.checkArgument((this._recordAggregator == null ? 1 : 0) != 0, (Object)"If group-by columns are not given, the record aggregator has to be null.");
            }
            return new SegmentConverter(this._inputIndexDirs, this._workingDir, this._tableName, this._segmentName, this._totalNumPartition, this._recordTransformer, this._recordPartitioner, this._recordAggregator, this._groupByColumns, this._tableConfig, this._skipTimeValueCheck);
        }
    }
}

