/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.minion.rollup;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.common.exception.InvalidConfigException;
import org.apache.pinot.core.minion.SegmentConverter;
import org.apache.pinot.core.minion.rollup.MergeType;
import org.apache.pinot.core.minion.rollup.RollupRecordAggregator;
import org.apache.pinot.core.segment.processing.transformer.RecordTransformer;
import org.apache.pinot.segment.spi.index.metadata.SegmentMetadataImpl;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.DateTimeFieldSpec;
import org.apache.pinot.spi.data.DimensionFieldSpec;
import org.apache.pinot.spi.data.Schema;

public class MergeRollupSegmentConverter {
    private List<File> _inputIndexDirs;
    private File _workingDir;
    private TableConfig _tableConfig;
    private String _tableName;
    private String _segmentName;
    private MergeType _mergeType;
    private Map<String, String> _rollupPreAggregateType;

    private MergeRollupSegmentConverter(List<File> inputIndexDirs, File workingDir, String tableName, String segmentName, MergeType mergeType, TableConfig tableConfig, @Nullable Map<String, String> rollupPreAggregateType) {
        this._inputIndexDirs = inputIndexDirs;
        this._workingDir = workingDir;
        this._tableName = tableName;
        this._segmentName = segmentName;
        this._mergeType = mergeType;
        this._tableConfig = tableConfig;
        this._rollupPreAggregateType = rollupPreAggregateType;
    }

    public List<File> convert() throws Exception {
        List<File> convertedSegments;
        switch (this._mergeType) {
            case CONCATENATE: {
                convertedSegments = this.concatenateSegments();
                break;
            }
            case ROLLUP: {
                Schema schema = new SegmentMetadataImpl(this._inputIndexDirs.get(0)).getSchema();
                convertedSegments = this.rollupSegments(schema);
                break;
            }
            default: {
                throw new InvalidConfigException("Invalid merge type : " + this._mergeType);
            }
        }
        return convertedSegments;
    }

    private List<File> concatenateSegments() throws Exception {
        SegmentConverter concatenateSegmentConverter = new SegmentConverter.Builder().setTableName(this._tableName).setSegmentName(this._segmentName).setInputIndexDirs(this._inputIndexDirs).setWorkingDir(this._workingDir).setRecordTransformer(row -> row).setTableConfig(this._tableConfig).build();
        return concatenateSegmentConverter.convertSegment();
    }

    private List<File> rollupSegments(Schema schema) throws Exception {
        ArrayList<String> groupByColumns = new ArrayList<String>();
        for (DimensionFieldSpec dimensionFieldSpec : schema.getDimensionFieldSpecs()) {
            groupByColumns.add(dimensionFieldSpec.getName());
        }
        for (DateTimeFieldSpec dateTimeFieldSpec : schema.getDateTimeFieldSpecs()) {
            groupByColumns.add(dateTimeFieldSpec.getName());
        }
        String timeColumnName = this._tableConfig.getValidationConfig().getTimeColumnName();
        if (timeColumnName != null && !groupByColumns.contains(timeColumnName)) {
            groupByColumns.add(timeColumnName);
        }
        RecordTransformer rollupRecordTransformer = row -> row;
        RollupRecordAggregator rollupRecordAggregator = new RollupRecordAggregator(schema, this._rollupPreAggregateType);
        SegmentConverter rollupSegmentConverter = new SegmentConverter.Builder().setTableName(this._tableName).setSegmentName(this._segmentName).setInputIndexDirs(this._inputIndexDirs).setWorkingDir(this._workingDir).setRecordTransformer(rollupRecordTransformer).setRecordAggregator(rollupRecordAggregator).setGroupByColumns(groupByColumns).setTableConfig(this._tableConfig).build();
        return rollupSegmentConverter.convertSegment();
    }

    public static class Builder {
        private List<File> _inputIndexDirs;
        private File _workingDir;
        private MergeType _mergeType;
        private String _tableName;
        private String _segmentName;
        private TableConfig _tableConfig;
        private Map<String, String> _rollupPreAggregateType;

        public Builder setInputIndexDirs(List<File> inputIndexDirs) {
            this._inputIndexDirs = inputIndexDirs;
            return this;
        }

        public Builder setWorkingDir(File workingDir) {
            this._workingDir = workingDir;
            return this;
        }

        public Builder setMergeType(MergeType mergeType) {
            this._mergeType = mergeType;
            return this;
        }

        public Builder setRollupPreAggregateType(Map<String, String> rollupPreAggregateType) {
            this._rollupPreAggregateType = rollupPreAggregateType;
            return this;
        }

        public Builder setTableConfig(TableConfig tableConfig) {
            this._tableConfig = tableConfig;
            return this;
        }

        public Builder setTableName(String tableName) {
            this._tableName = tableName;
            return this;
        }

        public Builder setSegmentName(String segmentName) {
            this._segmentName = segmentName;
            return this;
        }

        public MergeRollupSegmentConverter build() {
            return new MergeRollupSegmentConverter(this._inputIndexDirs, this._workingDir, this._tableName, this._segmentName, this._mergeType, this._tableConfig, this._rollupPreAggregateType);
        }
    }
}

