/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator;

import org.apache.pinot.common.utils.DataTable;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.core.operator.blocks.InstanceResponseBlock;
import org.apache.pinot.core.operator.blocks.IntermediateResultsBlock;

public class InstanceResponseOperator
extends BaseOperator<InstanceResponseBlock> {
    private static final String OPERATOR_NAME = "InstanceResponseOperator";
    private final Operator _operator;

    public InstanceResponseOperator(Operator combinedOperator) {
        this._operator = combinedOperator;
    }

    @Override
    protected InstanceResponseBlock getNextBlock() {
        long startWallClockTimeNs = System.nanoTime();
        IntermediateResultsBlock intermediateResultsBlock = (IntermediateResultsBlock)this._operator.nextBlock();
        InstanceResponseBlock instanceResponseBlock = new InstanceResponseBlock(intermediateResultsBlock);
        DataTable dataTable = instanceResponseBlock.getInstanceResponseDataTable();
        long endWallClockTimeNs = System.nanoTime();
        long multipleThreadCpuTimeNs = intermediateResultsBlock.getExecutionThreadCpuTimeNs();
        long totalWallClockTimeNs = endWallClockTimeNs - startWallClockTimeNs;
        int numServerThreads = intermediateResultsBlock.getNumServerThreads();
        long totalThreadCpuTimeNs = InstanceResponseOperator.calTotalThreadCpuTimeNs(totalWallClockTimeNs, multipleThreadCpuTimeNs, numServerThreads);
        dataTable.getMetadata().put(DataTable.MetadataKey.THREAD_CPU_TIME_NS.getName(), String.valueOf(totalThreadCpuTimeNs));
        return instanceResponseBlock;
    }

    public static long calTotalThreadCpuTimeNs(long totalWallClockTimeNs, long multipleThreadCpuTimeNs, int numServerThreads) {
        double perThreadCpuTimeNs = (double)multipleThreadCpuTimeNs * 1.0 / (double)numServerThreads;
        return Math.round((double)totalWallClockTimeNs + perThreadCpuTimeNs * (double)(numServerThreads - 1));
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }
}

