/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.core.common.DataBlockCache;
import org.apache.pinot.core.common.DataFetcher;
import org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.core.operator.ExecutionStatistics;
import org.apache.pinot.core.operator.blocks.DocIdSetBlock;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.segment.spi.datasource.DataSource;

public class ProjectionOperator
extends BaseOperator<ProjectionBlock> {
    private static final String OPERATOR_NAME = "ProjectionOperator";
    private final Map<String, DataSource> _dataSourceMap;
    private final BaseOperator<DocIdSetBlock> _docIdSetOperator;
    private final DataBlockCache _dataBlockCache;

    public ProjectionOperator(Map<String, DataSource> dataSourceMap, @Nullable BaseOperator<DocIdSetBlock> docIdSetOperator) {
        this._dataSourceMap = dataSourceMap;
        this._docIdSetOperator = docIdSetOperator;
        this._dataBlockCache = new DataBlockCache(new DataFetcher(dataSourceMap));
    }

    public Map<String, DataSource> getDataSourceMap() {
        return this._dataSourceMap;
    }

    @Override
    protected ProjectionBlock getNextBlock() {
        assert (this._docIdSetOperator != null);
        DocIdSetBlock docIdSetBlock = this._docIdSetOperator.nextBlock();
        if (docIdSetBlock == null) {
            return null;
        }
        this._dataBlockCache.initNewBlock(docIdSetBlock.getDocIdSet(), docIdSetBlock.getSearchableLength());
        return new ProjectionBlock(this._dataSourceMap, this._dataBlockCache);
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }

    @Override
    public ExecutionStatistics getExecutionStatistics() {
        return this._docIdSetOperator != null ? this._docIdSetOperator.getExecutionStatistics() : new ExecutionStatistics(0L, 0L, 0L, 0L);
    }
}

