/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.blocks;

import java.util.Map;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.common.Block;
import org.apache.pinot.core.common.BlockDocIdSet;
import org.apache.pinot.core.common.BlockDocIdValueSet;
import org.apache.pinot.core.common.BlockMetadata;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.docvalsets.TransformBlockValSet;
import org.apache.pinot.core.operator.transform.function.TransformFunction;

public class TransformBlock
implements Block {
    protected final ProjectionBlock _projectionBlock;
    protected final Map<ExpressionContext, TransformFunction> _transformFunctionMap;

    public TransformBlock(ProjectionBlock projectionBlock, Map<ExpressionContext, TransformFunction> transformFunctionMap) {
        this._projectionBlock = projectionBlock;
        this._transformFunctionMap = transformFunctionMap;
    }

    public int getNumDocs() {
        return this._projectionBlock.getNumDocs();
    }

    public BlockValSet getBlockValueSet(ExpressionContext expression) {
        if (expression.getType() == ExpressionContext.Type.IDENTIFIER) {
            return this._projectionBlock.getBlockValueSet(expression.getIdentifier());
        }
        return new TransformBlockValSet(this._projectionBlock, this._transformFunctionMap.get(expression));
    }

    public BlockValSet getBlockValueSet(String column) {
        return this._projectionBlock.getBlockValueSet(column);
    }

    @Override
    public BlockDocIdSet getBlockDocIdSet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockValSet getBlockValueSet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockDocIdValueSet getBlockDocIdValueSet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockMetadata getMetadata() {
        throw new UnsupportedOperationException();
    }
}

