/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.combine;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.pinot.common.exception.QueryException;
import org.apache.pinot.common.response.ProcessingException;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.core.operator.blocks.IntermediateResultsBlock;
import org.apache.pinot.core.operator.combine.CombineOperatorUtils;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.request.context.ThreadTimer;
import org.apache.pinot.core.query.scheduler.resources.ResourceManager;
import org.apache.pinot.core.util.trace.TraceRunnable;
import org.apache.pinot.spi.exception.EarlyTerminationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseCombineOperator
extends BaseOperator<IntermediateResultsBlock> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseCombineOperator.class);
    protected final List<Operator> _operators;
    protected final int _numOperators;
    protected final QueryContext _queryContext;
    protected final ExecutorService _executorService;
    protected final long _endTimeMs;
    protected final int _numTasks;
    protected final Future[] _futures;
    protected final BlockingQueue<IntermediateResultsBlock> _blockingQueue = new LinkedBlockingQueue<IntermediateResultsBlock>();
    protected final AtomicLong totalWorkerThreadCpuTimeNs = new AtomicLong(0L);

    protected BaseCombineOperator(List<Operator> operators, QueryContext queryContext, ExecutorService executorService, long endTimeMs, int numTasks) {
        this._operators = operators;
        this._numOperators = this._operators.size();
        this._queryContext = queryContext;
        this._executorService = executorService;
        this._endTimeMs = endTimeMs;
        this._numTasks = numTasks;
        this._futures = new Future[this._numTasks];
    }

    protected BaseCombineOperator(List<Operator> operators, QueryContext queryContext, ExecutorService executorService, long endTimeMs) {
        this(operators, queryContext, executorService, endTimeMs, CombineOperatorUtils.getNumThreadsForQuery(operators.size()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IntermediateResultsBlock getNextBlock() {
        IntermediateResultsBlock mergedBlock;
        final Phaser phaser = new Phaser(1);
        for (int i = 0; i < this._numTasks; ++i) {
            final int taskIndex = i;
            this._futures[i] = this._executorService.submit(new TraceRunnable(){

                @Override
                public void runJob() {
                    ThreadTimer executionThreadTimer = new ThreadTimer();
                    executionThreadTimer.start();
                    if (phaser.register() < 0) {
                        return;
                    }
                    try {
                        BaseCombineOperator.this.processSegments(taskIndex);
                    }
                    finally {
                        phaser.arriveAndDeregister();
                    }
                    BaseCombineOperator.this.totalWorkerThreadCpuTimeNs.getAndAdd(executionThreadTimer.stopAndGetThreadTimeNs());
                }
            });
        }
        try {
            mergedBlock = this.mergeResults();
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while merging results blocks (query: {})", (Object)this._queryContext, (Object)e);
            mergedBlock = new IntermediateResultsBlock((Exception)QueryException.getException((ProcessingException)QueryException.INTERNAL_ERROR, (Exception)e));
        }
        finally {
            for (Future future : this._futures) {
                if (future.isDone()) continue;
                future.cancel(true);
            }
            phaser.awaitAdvance(phaser.arriveAndDeregister());
        }
        int numServerThreads = Math.min(this._numTasks, ResourceManager.DEFAULT_QUERY_WORKER_THREADS);
        CombineOperatorUtils.setExecutionStatistics(mergedBlock, this._operators, this.totalWorkerThreadCpuTimeNs.get(), numServerThreads);
        return mergedBlock;
    }

    protected void processSegments(int taskIndex) {
        for (int operatorIndex = taskIndex; operatorIndex < this._numOperators; operatorIndex += this._numTasks) {
            try {
                IntermediateResultsBlock resultsBlock = (IntermediateResultsBlock)this._operators.get(operatorIndex).nextBlock();
                if (this.isQuerySatisfied(resultsBlock)) {
                    this._blockingQueue.offer(resultsBlock);
                    return;
                }
                this._blockingQueue.offer(resultsBlock);
                continue;
            }
            catch (EarlyTerminationException e) {
                return;
            }
            catch (Exception e) {
                LOGGER.error("Caught exception while executing operator of index: {} (query: {})", new Object[]{operatorIndex, this._queryContext, e});
                this._blockingQueue.offer(new IntermediateResultsBlock(e));
                return;
            }
        }
    }

    protected IntermediateResultsBlock mergeResults() throws Exception {
        IntermediateResultsBlock mergedBlock = null;
        for (int numBlocksMerged = 0; numBlocksMerged < this._numOperators; ++numBlocksMerged) {
            IntermediateResultsBlock blockToMerge = this._blockingQueue.poll(this._endTimeMs - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
            if (blockToMerge == null) {
                LOGGER.error("Timed out while polling results block, numBlocksMerged: {} (query: {})", (Object)numBlocksMerged, (Object)this._queryContext);
                return new IntermediateResultsBlock((Exception)QueryException.getException((ProcessingException)QueryException.EXECUTION_TIMEOUT_ERROR, (Exception)new TimeoutException("Timed out while polling results block")));
            }
            if (blockToMerge.getProcessingExceptions() != null) {
                return blockToMerge;
            }
            if (mergedBlock == null) {
                mergedBlock = blockToMerge;
                continue;
            }
            this.mergeResultsBlocks(mergedBlock, blockToMerge);
            if (!this.isQuerySatisfied(mergedBlock)) continue;
            return mergedBlock;
        }
        return mergedBlock;
    }

    protected boolean isQuerySatisfied(IntermediateResultsBlock resultsBlock) {
        return false;
    }

    protected abstract void mergeResultsBlocks(IntermediateResultsBlock var1, IntermediateResultsBlock var2);
}

