/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.combine;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.blocks.IntermediateResultsBlock;
import org.apache.pinot.core.operator.combine.BaseCombineOperator;
import org.apache.pinot.core.query.distinct.DistinctTable;
import org.apache.pinot.core.query.request.context.QueryContext;

public class DistinctCombineOperator
extends BaseCombineOperator {
    private static final String OPERATOR_NAME = "DistinctCombineOperator";
    private final boolean _hasOrderBy;

    public DistinctCombineOperator(List<Operator> operators, QueryContext queryContext, ExecutorService executorService, long endTimeMs) {
        super(operators, queryContext, executorService, endTimeMs);
        this._hasOrderBy = queryContext.getOrderByExpressions() != null;
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }

    @Override
    protected boolean isQuerySatisfied(IntermediateResultsBlock resultsBlock) {
        if (this._hasOrderBy) {
            return false;
        }
        List<Object> result = resultsBlock.getAggregationResult();
        assert (result != null && result.size() == 1 && result.get(0) instanceof DistinctTable);
        DistinctTable distinctTable = (DistinctTable)result.get(0);
        return distinctTable.size() >= this._queryContext.getLimit();
    }

    @Override
    protected void mergeResultsBlocks(IntermediateResultsBlock mergedBlock, IntermediateResultsBlock blockToMerge) {
        List<Object> mergedResults = mergedBlock.getAggregationResult();
        assert (mergedResults != null && mergedResults.size() == 1 && mergedResults.get(0) instanceof DistinctTable);
        DistinctTable mergedDistinctTable = (DistinctTable)mergedResults.get(0);
        List<Object> resultsToMerge = blockToMerge.getAggregationResult();
        assert (resultsToMerge != null && resultsToMerge.size() == 1 && resultsToMerge.get(0) instanceof DistinctTable);
        DistinctTable distinctTableToMerge = (DistinctTable)resultsToMerge.get(0);
        if (!mergedDistinctTable.isMainTable()) {
            DistinctTable mainDistinctTable = new DistinctTable(distinctTableToMerge.getDataSchema(), this._queryContext.getOrderByExpressions(), this._queryContext.getLimit());
            mainDistinctTable.mergeTable(mergedDistinctTable);
            mergedBlock.setAggregationResults(Collections.singletonList(mainDistinctTable));
            mergedDistinctTable = mainDistinctTable;
        }
        mergedDistinctTable.mergeTable(distinctTableToMerge);
    }
}

