/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.combine;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.pinot.common.exception.QueryException;
import org.apache.pinot.common.response.ProcessingException;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.blocks.IntermediateResultsBlock;
import org.apache.pinot.core.operator.combine.BaseCombineOperator;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.AggregationGroupByResult;
import org.apache.pinot.core.query.aggregation.groupby.AggregationGroupByTrimmingService;
import org.apache.pinot.core.query.aggregation.groupby.GroupKeyGenerator;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.spi.exception.EarlyTerminationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupByCombineOperator
extends BaseCombineOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(GroupByCombineOperator.class);
    private static final String OPERATOR_NAME = "GroupByCombineOperator";
    private static final int INTER_SEGMENT_NUM_GROUPS_LIMIT_FACTOR = 2;
    private final int _innerSegmentNumGroupsLimit;
    private final int _interSegmentNumGroupsLimit;
    private final ConcurrentHashMap<String, Object[]> _resultsMap = new ConcurrentHashMap();
    private final AtomicInteger _numGroups = new AtomicInteger();
    private final ConcurrentLinkedQueue<ProcessingException> _mergedProcessingExceptions = new ConcurrentLinkedQueue();
    private final AggregationFunction[] _aggregationFunctions;
    private final int _numAggregationFunctions;
    private final CountDownLatch _operatorLatch;

    public GroupByCombineOperator(List<Operator> operators, QueryContext queryContext, ExecutorService executorService, long endTimeMs, int innerSegmentNumGroupsLimit) {
        super(operators, queryContext, executorService, endTimeMs, operators.size());
        this._innerSegmentNumGroupsLimit = innerSegmentNumGroupsLimit;
        this._interSegmentNumGroupsLimit = (int)Math.min((long)innerSegmentNumGroupsLimit * 2L, Integer.MAX_VALUE);
        this._aggregationFunctions = this._queryContext.getAggregationFunctions();
        assert (this._aggregationFunctions != null);
        this._numAggregationFunctions = this._aggregationFunctions.length;
        this._operatorLatch = new CountDownLatch(this._numOperators);
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processSegments(int threadIndex) {
        try {
            AggregationGroupByResult aggregationGroupByResult;
            IntermediateResultsBlock intermediateResultsBlock = (IntermediateResultsBlock)((Operator)this._operators.get(threadIndex)).nextBlock();
            List<ProcessingException> processingExceptionsToMerge = intermediateResultsBlock.getProcessingExceptions();
            if (processingExceptionsToMerge != null) {
                this._mergedProcessingExceptions.addAll(processingExceptionsToMerge);
            }
            if ((aggregationGroupByResult = intermediateResultsBlock.getAggregationGroupByResult()) != null) {
                Iterator<GroupKeyGenerator.StringGroupKey> groupKeyIterator = aggregationGroupByResult.getStringGroupKeyIterator();
                while (groupKeyIterator.hasNext()) {
                    GroupKeyGenerator.StringGroupKey groupKey = groupKeyIterator.next();
                    this._resultsMap.compute(groupKey._stringKey, (key, value) -> {
                        block3: {
                            block2: {
                                if (value != null) break block2;
                                if (this._numGroups.getAndIncrement() >= this._interSegmentNumGroupsLimit) break block3;
                                value = new Object[this._numAggregationFunctions];
                                for (int i = 0; i < this._numAggregationFunctions; ++i) {
                                    value[i] = aggregationGroupByResult.getResultForKey(groupKey, i);
                                }
                                break block3;
                            }
                            for (int i = 0; i < this._numAggregationFunctions; ++i) {
                                value[i] = this._aggregationFunctions[i].merge(value[i], aggregationGroupByResult.getResultForKey(groupKey, i));
                            }
                        }
                        return value;
                    });
                }
            }
        }
        catch (EarlyTerminationException intermediateResultsBlock) {
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while processing and combining group-by for index: {}, operator: {}, queryContext: {}", new Object[]{threadIndex, ((Operator)this._operators.get(threadIndex)).getClass().getName(), this._queryContext, e});
            this._mergedProcessingExceptions.add(QueryException.getException((ProcessingException)QueryException.QUERY_EXECUTION_ERROR, (Exception)e));
        }
        finally {
            this._operatorLatch.countDown();
        }
    }

    @Override
    protected IntermediateResultsBlock mergeResults() throws Exception {
        long timeoutMs = this._endTimeMs - System.currentTimeMillis();
        boolean opCompleted = this._operatorLatch.await(timeoutMs, TimeUnit.MILLISECONDS);
        if (!opCompleted) {
            String errorMessage = String.format("Timed out while combining group-by results after %dms, queryContext = %s", timeoutMs, this._queryContext);
            LOGGER.error(errorMessage);
            return new IntermediateResultsBlock(new TimeoutException(errorMessage));
        }
        AggregationGroupByTrimmingService aggregationGroupByTrimmingService = new AggregationGroupByTrimmingService(this._queryContext);
        List<Map<String, Object>> trimmedResults = aggregationGroupByTrimmingService.trimIntermediateResultsMap(this._resultsMap);
        IntermediateResultsBlock mergedBlock = new IntermediateResultsBlock(this._aggregationFunctions, trimmedResults, true);
        if (!this._mergedProcessingExceptions.isEmpty()) {
            mergedBlock.setProcessingExceptions(new ArrayList<ProcessingException>(this._mergedProcessingExceptions));
        }
        if (this._resultsMap.size() >= this._innerSegmentNumGroupsLimit) {
            mergedBlock.setNumGroupsLimitReached(true);
        }
        return mergedBlock;
    }

    @Override
    protected void mergeResultsBlocks(IntermediateResultsBlock mergedBlock, IntermediateResultsBlock blockToMerge) {
    }
}

