/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.combine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.pinot.common.exception.QueryException;
import org.apache.pinot.common.response.ProcessingException;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.data.table.ConcurrentIndexedTable;
import org.apache.pinot.core.data.table.IntermediateRecord;
import org.apache.pinot.core.data.table.Key;
import org.apache.pinot.core.data.table.Record;
import org.apache.pinot.core.data.table.UnboundedConcurrentIndexedTable;
import org.apache.pinot.core.operator.blocks.IntermediateResultsBlock;
import org.apache.pinot.core.operator.combine.BaseCombineOperator;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.AggregationGroupByResult;
import org.apache.pinot.core.query.aggregation.groupby.GroupKeyGenerator;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.util.GroupByUtils;
import org.apache.pinot.spi.exception.EarlyTerminationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupByOrderByCombineOperator
extends BaseCombineOperator {
    public static final int MAX_TRIM_THRESHOLD = 1000000000;
    private static final Logger LOGGER = LoggerFactory.getLogger(GroupByOrderByCombineOperator.class);
    private static final String OPERATOR_NAME = "GroupByOrderByCombineOperator";
    private final int _trimSize;
    private final int _trimThreshold;
    private final Lock _initLock;
    private final int _numAggregationFunctions;
    private final int _numGroupByExpressions;
    private final int _numColumns;
    private final ConcurrentLinkedQueue<ProcessingException> _mergedProcessingExceptions = new ConcurrentLinkedQueue();
    private final CountDownLatch _operatorLatch;
    private DataSchema _dataSchema;
    private ConcurrentIndexedTable _indexedTable;

    public GroupByOrderByCombineOperator(List<Operator> operators, QueryContext queryContext, ExecutorService executorService, long endTimeMs, int trimThreshold) {
        super(operators, queryContext, executorService, endTimeMs, operators.size());
        this._initLock = new ReentrantLock();
        this._trimSize = GroupByUtils.getTableCapacity(this._queryContext);
        this._trimThreshold = trimThreshold;
        AggregationFunction[] aggregationFunctions = this._queryContext.getAggregationFunctions();
        assert (aggregationFunctions != null);
        this._numAggregationFunctions = aggregationFunctions.length;
        assert (this._queryContext.getGroupByExpressions() != null);
        this._numGroupByExpressions = this._queryContext.getGroupByExpressions().size();
        this._numColumns = this._numGroupByExpressions + this._numAggregationFunctions;
        int numOperators = this._operators.size();
        this._operatorLatch = new CountDownLatch(numOperators);
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processSegments(int threadIndex) {
        try {
            Collection<IntermediateRecord> intermediateRecords;
            IntermediateResultsBlock intermediateResultsBlock = (IntermediateResultsBlock)((Operator)this._operators.get(threadIndex)).nextBlock();
            this._initLock.lock();
            try {
                if (this._dataSchema == null) {
                    this._dataSchema = intermediateResultsBlock.getDataSchema();
                    this._indexedTable = this._trimThreshold >= 1000000000 ? new UnboundedConcurrentIndexedTable(this._dataSchema, this._queryContext, this._trimSize, this._trimThreshold) : new ConcurrentIndexedTable(this._dataSchema, this._queryContext, this._trimSize, this._trimThreshold);
                }
            }
            finally {
                this._initLock.unlock();
            }
            List<ProcessingException> processingExceptionsToMerge = intermediateResultsBlock.getProcessingExceptions();
            if (processingExceptionsToMerge != null) {
                this._mergedProcessingExceptions.addAll(processingExceptionsToMerge);
            }
            if ((intermediateRecords = intermediateResultsBlock.getIntermediateRecords()) == null) {
                AggregationGroupByResult aggregationGroupByResult = intermediateResultsBlock.getAggregationGroupByResult();
                if (aggregationGroupByResult != null) {
                    Iterator<GroupKeyGenerator.GroupKey> dicGroupKeyIterator = aggregationGroupByResult.getGroupKeyIterator();
                    while (dicGroupKeyIterator.hasNext()) {
                        GroupKeyGenerator.GroupKey groupKey = dicGroupKeyIterator.next();
                        Object[] keys = groupKey._keys;
                        Object[] values = Arrays.copyOf(keys, this._numColumns);
                        int groupId = groupKey._groupId;
                        for (int i = 0; i < this._numAggregationFunctions; ++i) {
                            values[this._numGroupByExpressions + i] = aggregationGroupByResult.getResultForGroupId(i, groupId);
                        }
                        this._indexedTable.upsert(new Key(keys), new Record(values));
                    }
                }
            } else {
                for (IntermediateRecord intermediateResult : intermediateRecords) {
                    this._indexedTable.upsert(intermediateResult._key, intermediateResult._record);
                }
            }
        }
        catch (EarlyTerminationException intermediateResultsBlock) {
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while processing and combining group-by order-by for index: {}, operator: {}, queryContext: {}", new Object[]{threadIndex, ((Operator)this._operators.get(threadIndex)).getClass().getName(), this._queryContext, e});
            this._mergedProcessingExceptions.add(QueryException.getException((ProcessingException)QueryException.QUERY_EXECUTION_ERROR, (Exception)e));
        }
        finally {
            this._operatorLatch.countDown();
        }
    }

    @Override
    protected IntermediateResultsBlock mergeResults() throws Exception {
        long timeoutMs = this._endTimeMs - System.currentTimeMillis();
        boolean opCompleted = this._operatorLatch.await(timeoutMs, TimeUnit.MILLISECONDS);
        if (!opCompleted) {
            String errorMessage = String.format("Timed out while combining group-by order-by results after %dms, queryContext = %s", timeoutMs, this._queryContext);
            LOGGER.error(errorMessage);
            return new IntermediateResultsBlock(new TimeoutException(errorMessage));
        }
        this._indexedTable.finish(false);
        IntermediateResultsBlock mergedBlock = new IntermediateResultsBlock(this._indexedTable);
        if (!this._mergedProcessingExceptions.isEmpty()) {
            mergedBlock.setProcessingExceptions(new ArrayList<ProcessingException>(this._mergedProcessingExceptions));
        }
        mergedBlock.setNumResizes(this._indexedTable.getNumResizes());
        mergedBlock.setResizeTimeMs(this._indexedTable.getResizeTimeMs());
        return mergedBlock;
    }

    @Override
    protected void mergeResultsBlocks(IntermediateResultsBlock mergedBlock, IntermediateResultsBlock blockToMerge) {
    }
}

