/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.combine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.PriorityQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pinot.common.exception.QueryException;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.common.response.ProcessingException;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.blocks.IntermediateResultsBlock;
import org.apache.pinot.core.operator.combine.BaseCombineOperator;
import org.apache.pinot.core.operator.query.SelectionOrderByOperator;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.selection.SelectionOperatorUtils;
import org.apache.pinot.segment.spi.datasource.DataSourceMetadata;
import org.apache.pinot.spi.exception.EarlyTerminationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinMaxValueBasedSelectionOrderByCombineOperator
extends BaseCombineOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(MinMaxValueBasedSelectionOrderByCombineOperator.class);
    private static final String OPERATOR_NAME = "MinMaxValueBasedSelectionOrderByCombineOperator";
    private static final IntermediateResultsBlock LAST_RESULTS_BLOCK = new IntermediateResultsBlock(new DataSchema(new String[0], new DataSchema.ColumnDataType[0]), Collections.emptyList());
    private final AtomicInteger _numOperatorsSkipped = new AtomicInteger();
    private final AtomicReference<Comparable> _globalBoundaryValue = new AtomicReference();
    private final int _numRowsToKeep;
    private final List<MinMaxValueContext> _minMaxValueContexts;

    MinMaxValueBasedSelectionOrderByCombineOperator(List<Operator> operators, QueryContext queryContext, ExecutorService executorService, long endTimeMs) {
        super(operators, queryContext, executorService, endTimeMs);
        this._numRowsToKeep = queryContext.getLimit() + queryContext.getOffset();
        List<OrderByExpressionContext> orderByExpressions = this._queryContext.getOrderByExpressions();
        assert (orderByExpressions != null);
        int numOrderByExpressions = orderByExpressions.size();
        assert (numOrderByExpressions > 0);
        OrderByExpressionContext firstOrderByExpression = orderByExpressions.get(0);
        assert (firstOrderByExpression.getExpression().getType() == ExpressionContext.Type.IDENTIFIER);
        String firstOrderByColumn = firstOrderByExpression.getExpression().getIdentifier();
        this._minMaxValueContexts = new ArrayList<MinMaxValueContext>(this._numOperators);
        for (Operator operator : this._operators) {
            this._minMaxValueContexts.add(new MinMaxValueContext((SelectionOrderByOperator)operator, firstOrderByColumn));
        }
        if (firstOrderByExpression.isAsc()) {
            this._minMaxValueContexts.sort((o1, o2) -> {
                if (o1._minValue == null) {
                    return o2._minValue == null ? 0 : -1;
                }
                if (o2._minValue == null) {
                    return 1;
                }
                return o1._minValue.compareTo(o2._minValue);
            });
        } else {
            this._minMaxValueContexts.sort((o1, o2) -> {
                if (o1._maxValue == null) {
                    return o2._maxValue == null ? 0 : -1;
                }
                if (o2._maxValue == null) {
                    return 1;
                }
                return o2._maxValue.compareTo(o1._maxValue);
            });
        }
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }

    @Override
    protected void processSegments(int threadIndex) {
        List<OrderByExpressionContext> orderByExpressions = this._queryContext.getOrderByExpressions();
        assert (orderByExpressions != null);
        int numOrderByExpressions = orderByExpressions.size();
        assert (numOrderByExpressions > 0);
        OrderByExpressionContext firstOrderByExpression = orderByExpressions.get(0);
        assert (firstOrderByExpression.getExpression().getType() == ExpressionContext.Type.IDENTIFIER);
        boolean asc = firstOrderByExpression.isAsc();
        Comparable threadBoundaryValue = null;
        for (int operatorIndex = threadIndex; operatorIndex < this._numOperators; operatorIndex += this._numTasks) {
            Comparable boundaryValue = this._globalBoundaryValue.get();
            if (boundaryValue == null) {
                boundaryValue = threadBoundaryValue;
            } else if (threadBoundaryValue != null) {
                if (asc) {
                    if (threadBoundaryValue.compareTo(boundaryValue) < 0) {
                        boundaryValue = threadBoundaryValue;
                    }
                } else if (threadBoundaryValue.compareTo(boundaryValue) > 0) {
                    boundaryValue = threadBoundaryValue;
                }
            }
            MinMaxValueContext minMaxValueContext = this._minMaxValueContexts.get(operatorIndex);
            if (boundaryValue != null) {
                int result;
                if (asc) {
                    int result2;
                    if (minMaxValueContext._minValue != null && ((result2 = minMaxValueContext._minValue.compareTo(boundaryValue)) > 0 || result2 == 0 && numOrderByExpressions == 1)) {
                        this._numOperatorsSkipped.getAndAdd((this._numOperators - operatorIndex - 1) / this._numTasks);
                        this._blockingQueue.offer(LAST_RESULTS_BLOCK);
                        return;
                    }
                } else if (minMaxValueContext._maxValue != null && ((result = minMaxValueContext._maxValue.compareTo(boundaryValue)) < 0 || result == 0 && numOrderByExpressions == 1)) {
                    this._numOperatorsSkipped.getAndAdd((this._numOperators - operatorIndex - 1) / this._numTasks);
                    this._blockingQueue.offer(LAST_RESULTS_BLOCK);
                    return;
                }
            }
            try {
                IntermediateResultsBlock resultsBlock = (IntermediateResultsBlock)minMaxValueContext._operator.nextBlock();
                PriorityQueue selectionResult = (PriorityQueue)resultsBlock.getSelectionResult();
                if (selectionResult != null && selectionResult.size() == this._numRowsToKeep) {
                    assert (selectionResult.peek() != null);
                    Comparable segmentBoundaryValue = (Comparable)((Object[])selectionResult.peek())[0];
                    if (boundaryValue == null) {
                        boundaryValue = segmentBoundaryValue;
                    } else if (asc) {
                        if (segmentBoundaryValue.compareTo(boundaryValue) < 0) {
                            boundaryValue = segmentBoundaryValue;
                        }
                    } else if (segmentBoundaryValue.compareTo(boundaryValue) > 0) {
                        boundaryValue = segmentBoundaryValue;
                    }
                }
                threadBoundaryValue = boundaryValue;
                this._blockingQueue.offer(resultsBlock);
                continue;
            }
            catch (EarlyTerminationException e) {
                return;
            }
            catch (Exception e) {
                LOGGER.error("Caught exception while executing operator of index: {} (query: {})", new Object[]{operatorIndex, this._queryContext, e});
                this._blockingQueue.offer(new IntermediateResultsBlock(e));
                return;
            }
        }
    }

    @Override
    protected IntermediateResultsBlock mergeResults() throws Exception {
        IntermediateResultsBlock mergedBlock = null;
        int numBlocksMerged = 0;
        while (numBlocksMerged + this._numOperatorsSkipped.get() < this._numOperators) {
            IntermediateResultsBlock blockToMerge = (IntermediateResultsBlock)this._blockingQueue.poll(this._endTimeMs - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
            if (blockToMerge == null) {
                LOGGER.error("Timed out while polling results block, numBlocksMerged: {} (query: {})", (Object)numBlocksMerged, (Object)this._queryContext);
                mergedBlock = new IntermediateResultsBlock((Exception)QueryException.getException((ProcessingException)QueryException.EXECUTION_TIMEOUT_ERROR, (Exception)new TimeoutException("Timed out while polling results block")));
                break;
            }
            if (blockToMerge.getProcessingExceptions() != null) {
                mergedBlock = blockToMerge;
                break;
            }
            if (mergedBlock == null) {
                mergedBlock = blockToMerge;
            } else if (blockToMerge != LAST_RESULTS_BLOCK) {
                this.mergeResultsBlocks(mergedBlock, blockToMerge);
            }
            ++numBlocksMerged;
            PriorityQueue selectionResult = (PriorityQueue)mergedBlock.getSelectionResult();
            if (selectionResult == null || selectionResult.size() != this._numRowsToKeep) continue;
            assert (selectionResult.peek() != null);
            this._globalBoundaryValue.set((Comparable)((Object[])selectionResult.peek())[0]);
        }
        return mergedBlock;
    }

    @Override
    protected void mergeResultsBlocks(IntermediateResultsBlock mergedBlock, IntermediateResultsBlock blockToMerge) {
        DataSchema mergedDataSchema = mergedBlock.getDataSchema();
        DataSchema dataSchemaToMerge = blockToMerge.getDataSchema();
        assert (mergedDataSchema != null && dataSchemaToMerge != null);
        if (!mergedDataSchema.equals((Object)dataSchemaToMerge)) {
            String errorMessage = String.format("Data schema mismatch between merged block: %s and block to merge: %s, drop block to merge", mergedDataSchema, dataSchemaToMerge);
            LOGGER.debug(errorMessage);
            mergedBlock.addToProcessingExceptions(QueryException.getException((ProcessingException)QueryException.MERGE_RESPONSE_ERROR, (String)errorMessage));
            return;
        }
        PriorityQueue mergedRows = (PriorityQueue)mergedBlock.getSelectionResult();
        Collection<Object[]> rowsToMerge = blockToMerge.getSelectionResult();
        assert (mergedRows != null && rowsToMerge != null);
        SelectionOperatorUtils.mergeWithOrdering(mergedRows, rowsToMerge, this._numRowsToKeep);
    }

    private static class MinMaxValueContext {
        final SelectionOrderByOperator _operator;
        final Comparable _minValue;
        final Comparable _maxValue;

        MinMaxValueContext(SelectionOrderByOperator operator, String column) {
            this._operator = operator;
            DataSourceMetadata dataSourceMetadata = operator.getIndexSegment().getDataSource(column).getDataSourceMetadata();
            this._minValue = dataSourceMetadata.getMinValue();
            this._maxValue = dataSourceMetadata.getMaxValue();
        }
    }
}

