/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.dociditerators;

import java.util.Map;
import org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.core.operator.BitmapDocIdSetOperator;
import org.apache.pinot.core.operator.ProjectionOperator;
import org.apache.pinot.core.operator.blocks.DocIdSetBlock;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.dociditerators.ScanBasedDocIdIterator;
import org.apache.pinot.core.operator.filter.predicate.PredicateEvaluator;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.core.plan.DocIdSetPlanNode;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.roaringbitmap.BitmapDataProvider;
import org.roaringbitmap.ImmutableBitmapDataProvider;
import org.roaringbitmap.PeekableIntIterator;
import org.roaringbitmap.RoaringBitmap;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public final class ExpressionScanDocIdIterator
implements ScanBasedDocIdIterator {
    private final TransformFunction _transformFunction;
    private final PredicateEvaluator _predicateEvaluator;
    private final Map<String, DataSource> _dataSourceMap;
    private final int _endDocId;
    private final int[] _docIdBuffer = new int[DocIdSetPlanNode.MAX_DOC_PER_CALL];
    private int _blockEndDocId = 0;
    private PeekableIntIterator _docIdIterator;
    private long _numEntriesScanned = 0L;

    public ExpressionScanDocIdIterator(TransformFunction transformFunction, PredicateEvaluator predicateEvaluator, Map<String, DataSource> dataSourceMap, int numDocs) {
        this._transformFunction = transformFunction;
        this._predicateEvaluator = predicateEvaluator;
        this._dataSourceMap = dataSourceMap;
        this._endDocId = numDocs;
    }

    @Override
    public int next() {
        if (this._docIdIterator != null && this._docIdIterator.hasNext()) {
            return this._docIdIterator.next();
        }
        while (this._blockEndDocId < this._endDocId) {
            int blockStartDocId = this._blockEndDocId;
            this._blockEndDocId = Math.min(blockStartDocId + DocIdSetPlanNode.MAX_DOC_PER_CALL, this._endDocId);
            ProjectionBlock projectionBlock = (ProjectionBlock)new ProjectionOperator(this._dataSourceMap, new RangeDocIdSetOperator(blockStartDocId, this._blockEndDocId)).nextBlock();
            RoaringBitmap matchingDocIds = new RoaringBitmap();
            this.processProjectionBlock(projectionBlock, (BitmapDataProvider)matchingDocIds);
            if (matchingDocIds.isEmpty()) continue;
            this._docIdIterator = matchingDocIds.getIntIterator();
            return this._docIdIterator.next();
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public int advance(int targetDocId) {
        if (targetDocId < this._blockEndDocId) {
            this._docIdIterator.advanceIfNeeded(targetDocId);
            if (this._docIdIterator.hasNext()) {
                return this._docIdIterator.next();
            }
        } else {
            this._blockEndDocId = targetDocId;
        }
        this._docIdIterator = null;
        return this.next();
    }

    @Override
    public MutableRoaringBitmap applyAnd(ImmutableRoaringBitmap docIds) {
        ProjectionBlock projectionBlock;
        ProjectionOperator projectionOperator = new ProjectionOperator(this._dataSourceMap, new BitmapDocIdSetOperator((ImmutableBitmapDataProvider)docIds, this._docIdBuffer));
        MutableRoaringBitmap matchingDocIds = new MutableRoaringBitmap();
        while ((projectionBlock = (ProjectionBlock)projectionOperator.nextBlock()) != null) {
            this.processProjectionBlock(projectionBlock, (BitmapDataProvider)matchingDocIds);
        }
        return matchingDocIds;
    }

    private void processProjectionBlock(ProjectionBlock projectionBlock, BitmapDataProvider matchingDocIds) {
        block32: {
            TransformResultMetadata resultMetadata;
            int numDocs;
            block30: {
                block31: {
                    numDocs = projectionBlock.getNumDocs();
                    resultMetadata = this._transformFunction.getResultMetadata();
                    if (!resultMetadata.isSingleValue()) break block30;
                    this._numEntriesScanned += (long)numDocs;
                    if (!resultMetadata.hasDictionary()) break block31;
                    int[] dictIds = this._transformFunction.transformToDictIdsSV(projectionBlock);
                    for (int i = 0; i < numDocs; ++i) {
                        if (!this._predicateEvaluator.applySV(dictIds[i])) continue;
                        matchingDocIds.add(this._docIdBuffer[i]);
                    }
                    break block32;
                }
                switch (resultMetadata.getDataType().getStoredType()) {
                    case INT: {
                        int[] intValues = this._transformFunction.transformToIntValuesSV(projectionBlock);
                        for (int i = 0; i < numDocs; ++i) {
                            if (!this._predicateEvaluator.applySV(intValues[i])) continue;
                            matchingDocIds.add(this._docIdBuffer[i]);
                        }
                        break block32;
                    }
                    case LONG: {
                        long[] longValues = this._transformFunction.transformToLongValuesSV(projectionBlock);
                        for (int i = 0; i < numDocs; ++i) {
                            if (!this._predicateEvaluator.applySV(longValues[i])) continue;
                            matchingDocIds.add(this._docIdBuffer[i]);
                        }
                        break block32;
                    }
                    case FLOAT: {
                        float[] floatValues = this._transformFunction.transformToFloatValuesSV(projectionBlock);
                        for (int i = 0; i < numDocs; ++i) {
                            if (!this._predicateEvaluator.applySV(floatValues[i])) continue;
                            matchingDocIds.add(this._docIdBuffer[i]);
                        }
                        break block32;
                    }
                    case DOUBLE: {
                        double[] doubleValues = this._transformFunction.transformToDoubleValuesSV(projectionBlock);
                        for (int i = 0; i < numDocs; ++i) {
                            if (!this._predicateEvaluator.applySV(doubleValues[i])) continue;
                            matchingDocIds.add(this._docIdBuffer[i]);
                        }
                        break block32;
                    }
                    case STRING: {
                        String[] stringValues = this._transformFunction.transformToStringValuesSV(projectionBlock);
                        for (int i = 0; i < numDocs; ++i) {
                            if (!this._predicateEvaluator.applySV(stringValues[i])) continue;
                            matchingDocIds.add(this._docIdBuffer[i]);
                        }
                        break block32;
                    }
                    case BYTES: {
                        byte[][] bytesValues = this._transformFunction.transformToBytesValuesSV(projectionBlock);
                        for (int i = 0; i < numDocs; ++i) {
                            if (!this._predicateEvaluator.applySV(bytesValues[i])) continue;
                            matchingDocIds.add(this._docIdBuffer[i]);
                        }
                        break block32;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            if (resultMetadata.hasDictionary()) {
                int[][] dictIdsArray = this._transformFunction.transformToDictIdsMV(projectionBlock);
                for (int i = 0; i < numDocs; ++i) {
                    int[] dictIds = dictIdsArray[i];
                    int numDictIds = dictIds.length;
                    this._numEntriesScanned += (long)numDictIds;
                    if (!this._predicateEvaluator.applyMV(dictIds, numDictIds)) continue;
                    matchingDocIds.add(this._docIdBuffer[i]);
                }
            } else {
                switch (resultMetadata.getDataType().getStoredType()) {
                    case INT: {
                        int[][] intValuesArray = this._transformFunction.transformToIntValuesMV(projectionBlock);
                        for (int i = 0; i < numDocs; ++i) {
                            int[] values = intValuesArray[i];
                            int numValues = values.length;
                            this._numEntriesScanned += (long)numValues;
                            if (!this._predicateEvaluator.applyMV(values, numValues)) continue;
                            matchingDocIds.add(this._docIdBuffer[i]);
                        }
                        break;
                    }
                    case LONG: {
                        long[][] longValuesArray = this._transformFunction.transformToLongValuesMV(projectionBlock);
                        for (int i = 0; i < numDocs; ++i) {
                            long[] values = longValuesArray[i];
                            int numValues = values.length;
                            this._numEntriesScanned += (long)numValues;
                            if (!this._predicateEvaluator.applyMV(values, numValues)) continue;
                            matchingDocIds.add(this._docIdBuffer[i]);
                        }
                        break;
                    }
                    case FLOAT: {
                        float[][] floatValuesArray = this._transformFunction.transformToFloatValuesMV(projectionBlock);
                        for (int i = 0; i < numDocs; ++i) {
                            float[] values = floatValuesArray[i];
                            int numValues = values.length;
                            this._numEntriesScanned += (long)numValues;
                            if (!this._predicateEvaluator.applyMV(values, numValues)) continue;
                            matchingDocIds.add(this._docIdBuffer[i]);
                        }
                        break;
                    }
                    case DOUBLE: {
                        double[][] doubleValuesArray = this._transformFunction.transformToDoubleValuesMV(projectionBlock);
                        for (int i = 0; i < numDocs; ++i) {
                            double[] values = doubleValuesArray[i];
                            int numValues = values.length;
                            this._numEntriesScanned += (long)numValues;
                            if (!this._predicateEvaluator.applyMV(values, numValues)) continue;
                            matchingDocIds.add(this._docIdBuffer[i]);
                        }
                        break;
                    }
                    case STRING: {
                        String[][] valuesArray = this._transformFunction.transformToStringValuesMV(projectionBlock);
                        for (int i = 0; i < numDocs; ++i) {
                            String[] values = valuesArray[i];
                            int numValues = values.length;
                            this._numEntriesScanned += (long)numValues;
                            if (!this._predicateEvaluator.applyMV(values, numValues)) continue;
                            matchingDocIds.add(this._docIdBuffer[i]);
                        }
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
        }
    }

    @Override
    public long getNumEntriesScanned() {
        return this._numEntriesScanned;
    }

    private class RangeDocIdSetOperator
    extends BaseOperator<DocIdSetBlock> {
        static final String OPERATOR_NAME = "RangeDocIdSetOperator";
        DocIdSetBlock _docIdSetBlock;

        RangeDocIdSetOperator(int startDocId, int endDocId) {
            int numDocs = endDocId - startDocId;
            for (int i = 0; i < numDocs; ++i) {
                ExpressionScanDocIdIterator.this._docIdBuffer[i] = startDocId + i;
            }
            this._docIdSetBlock = new DocIdSetBlock(ExpressionScanDocIdIterator.this._docIdBuffer, numDocs);
        }

        @Override
        protected DocIdSetBlock getNextBlock() {
            DocIdSetBlock docIdSetBlock = this._docIdSetBlock;
            this._docIdSetBlock = null;
            return docIdSetBlock;
        }

        @Override
        public String getOperatorName() {
            return OPERATOR_NAME;
        }
    }
}

