/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.docvalsets;

import javax.annotation.Nullable;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.core.plan.DocIdSetPlanNode;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;

public class TransformBlockValSet
implements BlockValSet {
    private final ProjectionBlock _projectionBlock;
    private final TransformFunction _transformFunction;
    private int[] _numMVEntries;

    public TransformBlockValSet(ProjectionBlock projectionBlock, TransformFunction transformFunction) {
        this._projectionBlock = projectionBlock;
        this._transformFunction = transformFunction;
    }

    @Override
    public FieldSpec.DataType getValueType() {
        return this._transformFunction.getResultMetadata().getDataType();
    }

    @Override
    public boolean isSingleValue() {
        return this._transformFunction.getResultMetadata().isSingleValue();
    }

    @Override
    @Nullable
    public Dictionary getDictionary() {
        return this._transformFunction.getDictionary();
    }

    @Override
    public int[] getDictionaryIdsSV() {
        return this._transformFunction.transformToDictIdsSV(this._projectionBlock);
    }

    @Override
    public int[] getIntValuesSV() {
        return this._transformFunction.transformToIntValuesSV(this._projectionBlock);
    }

    @Override
    public long[] getLongValuesSV() {
        return this._transformFunction.transformToLongValuesSV(this._projectionBlock);
    }

    @Override
    public float[] getFloatValuesSV() {
        return this._transformFunction.transformToFloatValuesSV(this._projectionBlock);
    }

    @Override
    public double[] getDoubleValuesSV() {
        return this._transformFunction.transformToDoubleValuesSV(this._projectionBlock);
    }

    @Override
    public String[] getStringValuesSV() {
        return this._transformFunction.transformToStringValuesSV(this._projectionBlock);
    }

    @Override
    public byte[][] getBytesValuesSV() {
        return this._transformFunction.transformToBytesValuesSV(this._projectionBlock);
    }

    @Override
    public int[][] getDictionaryIdsMV() {
        return this._transformFunction.transformToDictIdsMV(this._projectionBlock);
    }

    @Override
    public int[][] getIntValuesMV() {
        return this._transformFunction.transformToIntValuesMV(this._projectionBlock);
    }

    @Override
    public long[][] getLongValuesMV() {
        return this._transformFunction.transformToLongValuesMV(this._projectionBlock);
    }

    @Override
    public float[][] getFloatValuesMV() {
        return this._transformFunction.transformToFloatValuesMV(this._projectionBlock);
    }

    @Override
    public double[][] getDoubleValuesMV() {
        return this._transformFunction.transformToDoubleValuesMV(this._projectionBlock);
    }

    @Override
    public String[][] getStringValuesMV() {
        return this._transformFunction.transformToStringValuesMV(this._projectionBlock);
    }

    @Override
    public int[] getNumMVEntries() {
        if (this._numMVEntries == null) {
            this._numMVEntries = new int[DocIdSetPlanNode.MAX_DOC_PER_CALL];
        }
        int numDocs = this._projectionBlock.getNumDocs();
        TransformResultMetadata resultMetadata = this._transformFunction.getResultMetadata();
        if (resultMetadata.hasDictionary()) {
            int[][] dictionaryIds = this.getDictionaryIdsMV();
            for (int i = 0; i < numDocs; ++i) {
                this._numMVEntries[i] = dictionaryIds[i].length;
            }
            return this._numMVEntries;
        }
        switch (resultMetadata.getDataType().getStoredType()) {
            case INT: {
                int[][] intValues = this.getIntValuesMV();
                for (int i = 0; i < numDocs; ++i) {
                    this._numMVEntries[i] = intValues[i].length;
                }
                return this._numMVEntries;
            }
            case LONG: {
                long[][] longValues = this.getLongValuesMV();
                for (int i = 0; i < numDocs; ++i) {
                    this._numMVEntries[i] = longValues[i].length;
                }
                return this._numMVEntries;
            }
            case FLOAT: {
                float[][] floatValues = this.getFloatValuesMV();
                for (int i = 0; i < numDocs; ++i) {
                    this._numMVEntries[i] = floatValues[i].length;
                }
                return this._numMVEntries;
            }
            case DOUBLE: {
                double[][] doubleValues = this.getDoubleValuesMV();
                for (int i = 0; i < numDocs; ++i) {
                    this._numMVEntries[i] = doubleValues[i].length;
                }
                return this._numMVEntries;
            }
            case STRING: {
                String[][] stringValues = this.getStringValuesMV();
                for (int i = 0; i < numDocs; ++i) {
                    this._numMVEntries[i] = stringValues[i].length;
                }
                return this._numMVEntries;
            }
        }
        throw new IllegalStateException();
    }
}

