/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.predicate.Predicate;
import org.apache.pinot.core.operator.blocks.FilterBlock;
import org.apache.pinot.core.operator.docidsets.ExpressionFilterDocIdSet;
import org.apache.pinot.core.operator.filter.BaseFilterOperator;
import org.apache.pinot.core.operator.filter.predicate.PredicateEvaluator;
import org.apache.pinot.core.operator.filter.predicate.PredicateEvaluatorProvider;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunctionFactory;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.datasource.DataSource;

public class ExpressionFilterOperator
extends BaseFilterOperator {
    private static final String OPERATOR_NAME = "ExpressionFilterOperator";
    private final int _numDocs;
    private final Map<String, DataSource> _dataSourceMap;
    private final TransformFunction _transformFunction;
    private final PredicateEvaluator _predicateEvaluator;

    public ExpressionFilterOperator(IndexSegment segment, Predicate predicate, int numDocs) {
        this._numDocs = numDocs;
        this._dataSourceMap = new HashMap<String, DataSource>();
        HashSet columns = new HashSet();
        ExpressionContext lhs = predicate.getLhs();
        lhs.getColumns(columns);
        for (String column : columns) {
            this._dataSourceMap.put(column, segment.getDataSource(column));
        }
        this._transformFunction = TransformFunctionFactory.get(lhs, this._dataSourceMap);
        this._predicateEvaluator = PredicateEvaluatorProvider.getPredicateEvaluator(predicate, this._transformFunction.getDictionary(), this._transformFunction.getResultMetadata().getDataType());
    }

    @Override
    protected FilterBlock getNextBlock() {
        return new FilterBlock(new ExpressionFilterDocIdSet(this._transformFunction, this._predicateEvaluator, this._dataSourceMap, this._numDocs));
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }
}

