/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter;

import org.apache.pinot.core.operator.blocks.FilterBlock;
import org.apache.pinot.core.operator.docidsets.BitmapDocIdSet;
import org.apache.pinot.core.operator.filter.BaseFilterOperator;
import org.apache.pinot.segment.spi.index.reader.JsonIndexReader;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;

public class JsonMatchFilterOperator
extends BaseFilterOperator {
    private static final String OPERATOR_NAME = "JsonMatchFilterOperator";
    private final JsonIndexReader _jsonIndex;
    private final String _filterString;
    private final int _numDocs;

    public JsonMatchFilterOperator(JsonIndexReader jsonIndex, String filterString, int numDocs) {
        this._jsonIndex = jsonIndex;
        this._filterString = filterString;
        this._numDocs = numDocs;
    }

    @Override
    protected FilterBlock getNextBlock() {
        return new FilterBlock(new BitmapDocIdSet((ImmutableRoaringBitmap)this._jsonIndex.getMatchingDocIds(this._filterString), this._numDocs));
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }
}

