/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.pinot.core.operator.blocks.FilterBlock;
import org.apache.pinot.core.operator.docidsets.SortedDocIdSet;
import org.apache.pinot.core.operator.filter.BaseFilterOperator;
import org.apache.pinot.core.operator.filter.predicate.PredicateEvaluator;
import org.apache.pinot.core.operator.filter.predicate.RangePredicateEvaluatorFactory;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.index.reader.SortedIndexReader;
import org.apache.pinot.spi.utils.Pairs;

public class SortedIndexBasedFilterOperator
extends BaseFilterOperator {
    private static final String OPERATOR_NAME = "SortedIndexBasedFilterOperator";
    private final PredicateEvaluator _predicateEvaluator;
    private final SortedIndexReader<?> _sortedIndexReader;
    private final int _numDocs;

    SortedIndexBasedFilterOperator(PredicateEvaluator predicateEvaluator, DataSource dataSource, int numDocs) {
        this._predicateEvaluator = predicateEvaluator;
        this._sortedIndexReader = (SortedIndexReader)dataSource.getInvertedIndex();
        this._numDocs = numDocs;
    }

    @Override
    protected FilterBlock getNextBlock() {
        if (this._predicateEvaluator instanceof RangePredicateEvaluatorFactory.SortedDictionaryBasedRangePredicateEvaluator) {
            RangePredicateEvaluatorFactory.SortedDictionaryBasedRangePredicateEvaluator rangePredicateEvaluator = (RangePredicateEvaluatorFactory.SortedDictionaryBasedRangePredicateEvaluator)this._predicateEvaluator;
            int startDocId = ((Pairs.IntPair)this._sortedIndexReader.getDocIds(rangePredicateEvaluator.getStartDictId())).getLeft();
            int endDocId = ((Pairs.IntPair)this._sortedIndexReader.getDocIds(rangePredicateEvaluator.getEndDictId() - 1)).getRight();
            return new FilterBlock(new SortedDocIdSet(Collections.singletonList(new Pairs.IntPair(startDocId, endDocId))));
        }
        boolean exclusive = this._predicateEvaluator.isExclusive();
        int[] dictIds = exclusive ? this._predicateEvaluator.getNonMatchingDictIds() : this._predicateEvaluator.getMatchingDictIds();
        int numDictIds = dictIds.length;
        Preconditions.checkState((numDictIds > 0 ? 1 : 0) != 0);
        if (numDictIds == 1) {
            Pairs.IntPair docIdRange = (Pairs.IntPair)this._sortedIndexReader.getDocIds(dictIds[0]);
            if (exclusive) {
                int lastDocId;
                ArrayList<Pairs.IntPair> docIdRanges = new ArrayList<Pairs.IntPair>(2);
                int firstDocId = docIdRange.getLeft();
                if (firstDocId > 0) {
                    docIdRanges.add(new Pairs.IntPair(0, firstDocId - 1));
                }
                if ((lastDocId = docIdRange.getRight()) < this._numDocs - 1) {
                    docIdRanges.add(new Pairs.IntPair(lastDocId + 1, this._numDocs - 1));
                }
                return new FilterBlock(new SortedDocIdSet(docIdRanges));
            }
            return new FilterBlock(new SortedDocIdSet(Collections.singletonList(docIdRange)));
        }
        Arrays.sort(dictIds);
        ArrayList<Pairs.IntPair> docIdRanges = new ArrayList<Pairs.IntPair>();
        Pairs.IntPair lastDocIdRange = (Pairs.IntPair)this._sortedIndexReader.getDocIds(dictIds[0]);
        for (int i = 1; i < numDictIds; ++i) {
            Pairs.IntPair docIdRange = (Pairs.IntPair)this._sortedIndexReader.getDocIds(dictIds[i]);
            if (docIdRange.getLeft() == lastDocIdRange.getRight() + 1) {
                lastDocIdRange.setRight(docIdRange.getRight());
                continue;
            }
            docIdRanges.add(lastDocIdRange);
            lastDocIdRange = docIdRange;
        }
        docIdRanges.add(lastDocIdRange);
        if (exclusive) {
            int numDocIdRanges = docIdRanges.size();
            ArrayList<Pairs.IntPair> invertedDocIdRanges = new ArrayList<Pairs.IntPair>(numDocIdRanges + 1);
            int firstDocId = ((Pairs.IntPair)docIdRanges.get(0)).getLeft();
            if (firstDocId > 0) {
                invertedDocIdRanges.add(new Pairs.IntPair(0, firstDocId - 1));
            }
            for (int i = 0; i < numDocIdRanges - 1; ++i) {
                invertedDocIdRanges.add(new Pairs.IntPair(((Pairs.IntPair)docIdRanges.get(i)).getRight() + 1, ((Pairs.IntPair)docIdRanges.get(i + 1)).getLeft() - 1));
            }
            int lastDocId = ((Pairs.IntPair)docIdRanges.get(numDocIdRanges - 1)).getRight();
            if (lastDocId < this._numDocs - 1) {
                invertedDocIdRanges.add(new Pairs.IntPair(lastDocId + 1, this._numDocs - 1));
            }
            docIdRanges = invertedDocIdRanges;
        }
        return new FilterBlock(new SortedDocIdSet(docIdRanges));
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }
}

