/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter.predicate;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import org.apache.pinot.common.request.context.predicate.Predicate;
import org.apache.pinot.core.operator.filter.predicate.BaseDictionaryBasedPredicateEvaluator;
import org.apache.pinot.segment.local.utils.fst.RegexpMatcher;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.segment.spi.index.reader.TextIndexReader;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;

public class FSTBasedRegexpPredicateEvaluatorFactory {
    public static BaseDictionaryBasedPredicateEvaluator newFSTBasedEvaluator(TextIndexReader fstIndexReader, Dictionary dictionary, String regexpQuery) {
        return new FSTBasedRegexpPredicateEvaluator(fstIndexReader, dictionary, regexpQuery);
    }

    public static BaseDictionaryBasedPredicateEvaluator newAutomatonBasedEvaluator(Dictionary dictionary, String regexpQuery) {
        return new AutomatonBasedRegexpPredicateEvaluator(regexpQuery, dictionary);
    }

    private static class FSTBasedRegexpPredicateEvaluator
    extends BaseDictionaryBasedPredicateEvaluator {
        private final TextIndexReader _fstIndexReader;
        private final String _searchQuery;
        private final ImmutableRoaringBitmap _dictIds;
        private final Dictionary _dictionary;

        public FSTBasedRegexpPredicateEvaluator(TextIndexReader fstIndexReader, Dictionary dictionary, String searchQuery) {
            this._dictionary = dictionary;
            this._fstIndexReader = fstIndexReader;
            this._searchQuery = searchQuery;
            this._dictIds = this._fstIndexReader.getDictIds(this._searchQuery);
        }

        @Override
        public boolean isAlwaysFalse() {
            return this._dictIds.isEmpty();
        }

        @Override
        public boolean isAlwaysTrue() {
            return this._dictIds.getCardinality() == this._dictionary.length();
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.REGEXP_LIKE;
        }

        @Override
        public boolean applySV(int dictId) {
            return this._dictIds.contains(dictId);
        }

        @Override
        public int[] getMatchingDictIds() {
            return this._dictIds.toArray();
        }
    }

    private static class AutomatonBasedRegexpPredicateEvaluator
    extends BaseDictionaryBasedPredicateEvaluator {
        private final RegexpMatcher _regexpMatcher;
        private final Dictionary _dictionary;
        int[] _matchingDictIds;

        public AutomatonBasedRegexpPredicateEvaluator(String searchQuery, Dictionary dictionary) {
            this._regexpMatcher = new RegexpMatcher(searchQuery, null);
            this._dictionary = dictionary;
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.REGEXP_LIKE;
        }

        @Override
        public boolean applySV(int dictId) {
            return this._regexpMatcher.match(this._dictionary.getStringValue(dictId));
        }

        @Override
        public int[] getMatchingDictIds() {
            if (this._matchingDictIds == null) {
                IntArrayList matchingDictIds = new IntArrayList();
                int dictionarySize = this._dictionary.length();
                for (int dictId = 0; dictId < dictionarySize; ++dictId) {
                    if (!this.applySV(dictId)) continue;
                    matchingDictIds.add(dictId);
                }
                this._matchingDictIds = matchingDictIds.toIntArray();
            }
            return this._matchingDictIds;
        }
    }
}

