/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter.predicate;

import it.unimi.dsi.fastutil.doubles.DoubleOpenHashSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatOpenHashSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Set;
import org.apache.pinot.common.request.context.predicate.InPredicate;
import org.apache.pinot.common.request.context.predicate.Predicate;
import org.apache.pinot.common.utils.HashUtil;
import org.apache.pinot.core.operator.filter.predicate.BaseDictionaryBasedPredicateEvaluator;
import org.apache.pinot.core.operator.filter.predicate.BaseRawValueBasedPredicateEvaluator;
import org.apache.pinot.core.operator.filter.predicate.PredicateUtils;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.BooleanUtils;
import org.apache.pinot.spi.utils.ByteArray;
import org.apache.pinot.spi.utils.BytesUtils;
import org.apache.pinot.spi.utils.TimestampUtils;

public class InPredicateEvaluatorFactory {
    private InPredicateEvaluatorFactory() {
    }

    public static BaseDictionaryBasedPredicateEvaluator newDictionaryBasedEvaluator(InPredicate inPredicate, Dictionary dictionary, FieldSpec.DataType dataType) {
        return new DictionaryBasedInPredicateEvaluator(inPredicate, dictionary, dataType);
    }

    public static BaseRawValueBasedPredicateEvaluator newRawValueBasedEvaluator(InPredicate inPredicate, FieldSpec.DataType dataType) {
        List values = inPredicate.getValues();
        int hashSetSize = HashUtil.getMinHashSetSize((int)values.size());
        switch (dataType) {
            case INT: {
                IntOpenHashSet matchingValues = new IntOpenHashSet(hashSetSize);
                for (String value : values) {
                    matchingValues.add(Integer.parseInt(value));
                }
                return new IntRawValueBasedInPredicateEvaluator((IntSet)matchingValues);
            }
            case LONG: {
                LongOpenHashSet matchingValues = new LongOpenHashSet(hashSetSize);
                for (String value : values) {
                    matchingValues.add(Long.parseLong(value));
                }
                return new LongRawValueBasedInPredicateEvaluator((LongSet)matchingValues);
            }
            case FLOAT: {
                FloatOpenHashSet matchingValues = new FloatOpenHashSet(hashSetSize);
                for (String value : values) {
                    matchingValues.add(Float.parseFloat(value));
                }
                return new FloatRawValueBasedInPredicateEvaluator((FloatSet)matchingValues);
            }
            case DOUBLE: {
                DoubleOpenHashSet matchingValues = new DoubleOpenHashSet(hashSetSize);
                for (String value : values) {
                    matchingValues.add(Double.parseDouble(value));
                }
                return new DoubleRawValueBasedInPredicateEvaluator((DoubleSet)matchingValues);
            }
            case BOOLEAN: {
                IntOpenHashSet matchingValues = new IntOpenHashSet(hashSetSize);
                for (String value : values) {
                    matchingValues.add(BooleanUtils.toInt((String)value));
                }
                return new IntRawValueBasedInPredicateEvaluator((IntSet)matchingValues);
            }
            case TIMESTAMP: {
                LongOpenHashSet matchingValues = new LongOpenHashSet(hashSetSize);
                for (String value : values) {
                    matchingValues.add(TimestampUtils.toMillisSinceEpoch((String)value));
                }
                return new LongRawValueBasedInPredicateEvaluator((LongSet)matchingValues);
            }
            case STRING: {
                ObjectOpenHashSet matchingValues = new ObjectOpenHashSet(hashSetSize);
                matchingValues.addAll(values);
                return new StringRawValueBasedInPredicateEvaluator((Set<String>)matchingValues);
            }
            case BYTES: {
                ObjectOpenHashSet matchingValues = new ObjectOpenHashSet(hashSetSize);
                for (String value : values) {
                    matchingValues.add(BytesUtils.toByteArray((String)value));
                }
                return new BytesRawValueBasedInPredicateEvaluator((Set<ByteArray>)matchingValues);
            }
        }
        throw new IllegalStateException("Unsupported data type: " + dataType);
    }

    private static final class BytesRawValueBasedInPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final Set<ByteArray> _matchingValues;

        BytesRawValueBasedInPredicateEvaluator(Set<ByteArray> matchingValues) {
            this._matchingValues = matchingValues;
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.IN;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.BYTES;
        }

        @Override
        public boolean applySV(byte[] value) {
            return this._matchingValues.contains(new ByteArray(value));
        }
    }

    private static final class StringRawValueBasedInPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final Set<String> _matchingValues;

        StringRawValueBasedInPredicateEvaluator(Set<String> matchingValues) {
            this._matchingValues = matchingValues;
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.IN;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.STRING;
        }

        @Override
        public boolean applySV(String value) {
            return this._matchingValues.contains(value);
        }
    }

    private static final class DoubleRawValueBasedInPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final DoubleSet _matchingValues;

        DoubleRawValueBasedInPredicateEvaluator(DoubleSet matchingValues) {
            this._matchingValues = matchingValues;
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.IN;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.DOUBLE;
        }

        @Override
        public boolean applySV(double value) {
            return this._matchingValues.contains(value);
        }
    }

    private static final class FloatRawValueBasedInPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final FloatSet _matchingValues;

        FloatRawValueBasedInPredicateEvaluator(FloatSet matchingValues) {
            this._matchingValues = matchingValues;
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.IN;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.FLOAT;
        }

        @Override
        public boolean applySV(float value) {
            return this._matchingValues.contains(value);
        }
    }

    private static final class LongRawValueBasedInPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final LongSet _matchingValues;

        LongRawValueBasedInPredicateEvaluator(LongSet matchingValues) {
            this._matchingValues = matchingValues;
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.IN;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.LONG;
        }

        @Override
        public boolean applySV(long value) {
            return this._matchingValues.contains(value);
        }
    }

    private static final class IntRawValueBasedInPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final IntSet _matchingValues;

        IntRawValueBasedInPredicateEvaluator(IntSet matchingValues) {
            this._matchingValues = matchingValues;
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.IN;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.INT;
        }

        @Override
        public boolean applySV(int value) {
            return this._matchingValues.contains(value);
        }
    }

    private static final class DictionaryBasedInPredicateEvaluator
    extends BaseDictionaryBasedPredicateEvaluator {
        final IntSet _matchingDictIdSet;
        final int _numMatchingDictIds;
        int[] _matchingDictIds;

        DictionaryBasedInPredicateEvaluator(InPredicate inPredicate, Dictionary dictionary, FieldSpec.DataType dataType) {
            List values = inPredicate.getValues();
            this._matchingDictIdSet = new IntOpenHashSet(HashUtil.getMinHashSetSize((int)values.size()));
            for (String value : values) {
                int dictId = dictionary.indexOf(PredicateUtils.getStoredValue(value, dataType));
                if (dictId < 0) continue;
                this._matchingDictIdSet.add(dictId);
            }
            this._numMatchingDictIds = this._matchingDictIdSet.size();
            if (this._numMatchingDictIds == 0) {
                this._alwaysFalse = true;
            } else if (dictionary.length() == this._numMatchingDictIds) {
                this._alwaysTrue = true;
            }
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.IN;
        }

        @Override
        public boolean applySV(int dictId) {
            return this._matchingDictIdSet.contains(dictId);
        }

        @Override
        public int getNumMatchingDictIds() {
            return this._numMatchingDictIds;
        }

        @Override
        public int[] getMatchingDictIds() {
            if (this._matchingDictIds == null) {
                this._matchingDictIds = this._matchingDictIdSet.toIntArray();
            }
            return this._matchingDictIds;
        }
    }
}

