/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter.predicate;

import java.util.Arrays;
import org.apache.pinot.common.request.context.predicate.NotEqPredicate;
import org.apache.pinot.common.request.context.predicate.Predicate;
import org.apache.pinot.core.operator.filter.predicate.BaseDictionaryBasedPredicateEvaluator;
import org.apache.pinot.core.operator.filter.predicate.BaseRawValueBasedPredicateEvaluator;
import org.apache.pinot.core.operator.filter.predicate.PredicateUtils;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.BooleanUtils;
import org.apache.pinot.spi.utils.BytesUtils;
import org.apache.pinot.spi.utils.TimestampUtils;

public class NotEqualsPredicateEvaluatorFactory {
    private NotEqualsPredicateEvaluatorFactory() {
    }

    public static BaseDictionaryBasedPredicateEvaluator newDictionaryBasedEvaluator(NotEqPredicate notEqPredicate, Dictionary dictionary, FieldSpec.DataType dataType) {
        return new DictionaryBasedNeqPredicateEvaluator(notEqPredicate, dictionary, dataType);
    }

    public static BaseRawValueBasedPredicateEvaluator newRawValueBasedEvaluator(NotEqPredicate notEqPredicate, FieldSpec.DataType dataType) {
        String value = notEqPredicate.getValue();
        switch (dataType) {
            case INT: {
                return new IntRawValueBasedNeqPredicateEvaluator(Integer.parseInt(value));
            }
            case LONG: {
                return new LongRawValueBasedNeqPredicateEvaluator(Long.parseLong(value));
            }
            case FLOAT: {
                return new FloatRawValueBasedNeqPredicateEvaluator(Float.parseFloat(value));
            }
            case DOUBLE: {
                return new DoubleRawValueBasedNeqPredicateEvaluator(Double.parseDouble(value));
            }
            case BOOLEAN: {
                return new IntRawValueBasedNeqPredicateEvaluator(BooleanUtils.toInt((String)value));
            }
            case TIMESTAMP: {
                return new LongRawValueBasedNeqPredicateEvaluator(TimestampUtils.toMillisSinceEpoch((String)value));
            }
            case STRING: {
                return new StringRawValueBasedNeqPredicateEvaluator(value);
            }
            case BYTES: {
                return new BytesRawValueBasedNeqPredicateEvaluator(BytesUtils.toBytes((String)value));
            }
        }
        throw new IllegalStateException("Unsupported data type: " + dataType);
    }

    private static final class BytesRawValueBasedNeqPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final byte[] _nonMatchingValue;

        BytesRawValueBasedNeqPredicateEvaluator(byte[] nonMatchingValue) {
            this._nonMatchingValue = nonMatchingValue;
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.NOT_EQ;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.BYTES;
        }

        @Override
        public boolean applySV(byte[] value) {
            return !Arrays.equals(this._nonMatchingValue, value);
        }
    }

    private static final class StringRawValueBasedNeqPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final String _nonMatchingValue;

        StringRawValueBasedNeqPredicateEvaluator(String nonMatchingValue) {
            this._nonMatchingValue = nonMatchingValue;
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.NOT_EQ;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.STRING;
        }

        @Override
        public boolean applySV(String value) {
            return !this._nonMatchingValue.equals(value);
        }
    }

    private static final class DoubleRawValueBasedNeqPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final double _nonMatchingValue;

        DoubleRawValueBasedNeqPredicateEvaluator(double nonMatchingValue) {
            this._nonMatchingValue = nonMatchingValue;
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.NOT_EQ;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.DOUBLE;
        }

        @Override
        public boolean applySV(double value) {
            return this._nonMatchingValue != value;
        }
    }

    private static final class FloatRawValueBasedNeqPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final float _nonMatchingValue;

        FloatRawValueBasedNeqPredicateEvaluator(float nonMatchingValue) {
            this._nonMatchingValue = nonMatchingValue;
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.NOT_EQ;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.FLOAT;
        }

        @Override
        public boolean applySV(float value) {
            return this._nonMatchingValue != value;
        }
    }

    private static final class LongRawValueBasedNeqPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final long _nonMatchingValue;

        LongRawValueBasedNeqPredicateEvaluator(long nonMatchingValue) {
            this._nonMatchingValue = nonMatchingValue;
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.NOT_EQ;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.LONG;
        }

        @Override
        public boolean applySV(long value) {
            return this._nonMatchingValue != value;
        }
    }

    private static final class IntRawValueBasedNeqPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final int _nonMatchingValue;

        IntRawValueBasedNeqPredicateEvaluator(int nonMatchingValue) {
            this._nonMatchingValue = nonMatchingValue;
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.NOT_EQ;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.INT;
        }

        @Override
        public boolean applySV(int value) {
            return this._nonMatchingValue != value;
        }
    }

    private static final class DictionaryBasedNeqPredicateEvaluator
    extends BaseDictionaryBasedPredicateEvaluator {
        final int _nonMatchingDictId;
        final int[] _nonMatchingDictIds;
        final Dictionary _dictionary;
        int[] _matchingDictIds;

        DictionaryBasedNeqPredicateEvaluator(NotEqPredicate nEqPredicate, Dictionary dictionary, FieldSpec.DataType dataType) {
            String predicateValue = PredicateUtils.getStoredValue(nEqPredicate.getValue(), dataType);
            this._nonMatchingDictId = dictionary.indexOf(predicateValue);
            if (this._nonMatchingDictId >= 0) {
                this._nonMatchingDictIds = new int[]{this._nonMatchingDictId};
                if (dictionary.length() == 1) {
                    this._alwaysFalse = true;
                }
            } else {
                this._nonMatchingDictIds = new int[0];
                this._alwaysTrue = true;
            }
            this._dictionary = dictionary;
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.NOT_EQ;
        }

        @Override
        public boolean applySV(int dictId) {
            return this._nonMatchingDictId != dictId;
        }

        @Override
        public int[] getMatchingDictIds() {
            block4: {
                if (this._matchingDictIds != null) break block4;
                int dictionarySize = this._dictionary.length();
                if (this._nonMatchingDictId >= 0) {
                    this._matchingDictIds = new int[dictionarySize - 1];
                    int index = 0;
                    for (int dictId = 0; dictId < dictionarySize; ++dictId) {
                        if (dictId == this._nonMatchingDictId) continue;
                        this._matchingDictIds[index++] = dictId;
                    }
                } else {
                    this._matchingDictIds = new int[dictionarySize];
                    for (int dictId = 0; dictId < dictionarySize; ++dictId) {
                        this._matchingDictIds[dictId] = dictId;
                    }
                }
            }
            return this._matchingDictIds;
        }

        @Override
        public int[] getNonMatchingDictIds() {
            return this._nonMatchingDictIds;
        }
    }
}

