/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter.predicate;

import it.unimi.dsi.fastutil.doubles.DoubleOpenHashSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatOpenHashSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Set;
import org.apache.pinot.common.request.context.predicate.NotInPredicate;
import org.apache.pinot.common.request.context.predicate.Predicate;
import org.apache.pinot.common.utils.HashUtil;
import org.apache.pinot.core.operator.filter.predicate.BaseDictionaryBasedPredicateEvaluator;
import org.apache.pinot.core.operator.filter.predicate.BaseRawValueBasedPredicateEvaluator;
import org.apache.pinot.core.operator.filter.predicate.PredicateUtils;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.BooleanUtils;
import org.apache.pinot.spi.utils.ByteArray;
import org.apache.pinot.spi.utils.BytesUtils;
import org.apache.pinot.spi.utils.TimestampUtils;

public class NotInPredicateEvaluatorFactory {
    private NotInPredicateEvaluatorFactory() {
    }

    public static BaseDictionaryBasedPredicateEvaluator newDictionaryBasedEvaluator(NotInPredicate notInPredicate, Dictionary dictionary, FieldSpec.DataType dataType) {
        return new DictionaryBasedNotInPredicateEvaluator(notInPredicate, dictionary, dataType);
    }

    public static BaseRawValueBasedPredicateEvaluator newRawValueBasedEvaluator(NotInPredicate notInPredicate, FieldSpec.DataType dataType) {
        List values = notInPredicate.getValues();
        int hashSetSize = HashUtil.getMinHashSetSize((int)values.size());
        switch (dataType) {
            case INT: {
                IntOpenHashSet nonMatchingValues = new IntOpenHashSet(hashSetSize);
                for (String value : values) {
                    nonMatchingValues.add(Integer.parseInt(value));
                }
                return new IntRawValueBasedNotInPredicateEvaluator((IntSet)nonMatchingValues);
            }
            case LONG: {
                LongOpenHashSet nonMatchingValues = new LongOpenHashSet(hashSetSize);
                for (String value : values) {
                    nonMatchingValues.add(Long.parseLong(value));
                }
                return new LongRawValueBasedNotInPredicateEvaluator((LongSet)nonMatchingValues);
            }
            case FLOAT: {
                FloatOpenHashSet nonMatchingValues = new FloatOpenHashSet(hashSetSize);
                for (String value : values) {
                    nonMatchingValues.add(Float.parseFloat(value));
                }
                return new FloatRawValueBasedNotInPredicateEvaluator((FloatSet)nonMatchingValues);
            }
            case DOUBLE: {
                DoubleOpenHashSet nonMatchingValues = new DoubleOpenHashSet(hashSetSize);
                for (String value : values) {
                    nonMatchingValues.add(Double.parseDouble(value));
                }
                return new DoubleRawValueBasedNotInPredicateEvaluator((DoubleSet)nonMatchingValues);
            }
            case BOOLEAN: {
                IntOpenHashSet nonMatchingValues = new IntOpenHashSet(hashSetSize);
                for (String value : values) {
                    nonMatchingValues.add(BooleanUtils.toInt((String)value));
                }
                return new IntRawValueBasedNotInPredicateEvaluator((IntSet)nonMatchingValues);
            }
            case TIMESTAMP: {
                LongOpenHashSet nonMatchingValues = new LongOpenHashSet(hashSetSize);
                for (String value : values) {
                    nonMatchingValues.add(TimestampUtils.toMillisSinceEpoch((String)value));
                }
                return new LongRawValueBasedNotInPredicateEvaluator((LongSet)nonMatchingValues);
            }
            case STRING: {
                ObjectOpenHashSet nonMatchingValues = new ObjectOpenHashSet(hashSetSize);
                nonMatchingValues.addAll(values);
                return new StringRawValueBasedNotInPredicateEvaluator((Set<String>)nonMatchingValues);
            }
            case BYTES: {
                ObjectOpenHashSet nonMatchingValues = new ObjectOpenHashSet(hashSetSize);
                for (String value : values) {
                    nonMatchingValues.add(BytesUtils.toByteArray((String)value));
                }
                return new BytesRawValueBasedNotInPredicateEvaluator((Set<ByteArray>)nonMatchingValues);
            }
        }
        throw new IllegalStateException("Unsupported data type: " + dataType);
    }

    private static final class BytesRawValueBasedNotInPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final Set<ByteArray> _nonMatchingValues;

        BytesRawValueBasedNotInPredicateEvaluator(Set<ByteArray> nonMatchingValues) {
            this._nonMatchingValues = nonMatchingValues;
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.NOT_IN;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.BYTES;
        }

        @Override
        public boolean applySV(byte[] value) {
            return !this._nonMatchingValues.contains(new ByteArray(value));
        }
    }

    private static final class StringRawValueBasedNotInPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final Set<String> _nonMatchingValues;

        StringRawValueBasedNotInPredicateEvaluator(Set<String> nonMatchingValues) {
            this._nonMatchingValues = nonMatchingValues;
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.NOT_IN;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.STRING;
        }

        @Override
        public boolean applySV(String value) {
            return !this._nonMatchingValues.contains(value);
        }
    }

    private static final class DoubleRawValueBasedNotInPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final DoubleSet _nonMatchingValues;

        DoubleRawValueBasedNotInPredicateEvaluator(DoubleSet nonMatchingValues) {
            this._nonMatchingValues = nonMatchingValues;
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.NOT_IN;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.DOUBLE;
        }

        @Override
        public boolean applySV(double value) {
            return !this._nonMatchingValues.contains(value);
        }
    }

    private static final class FloatRawValueBasedNotInPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final FloatSet _nonMatchingValues;

        FloatRawValueBasedNotInPredicateEvaluator(FloatSet nonMatchingValues) {
            this._nonMatchingValues = nonMatchingValues;
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.NOT_IN;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.FLOAT;
        }

        @Override
        public boolean applySV(float value) {
            return !this._nonMatchingValues.contains(value);
        }
    }

    private static final class LongRawValueBasedNotInPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final LongSet _nonMatchingValues;

        LongRawValueBasedNotInPredicateEvaluator(LongSet nonMatchingValues) {
            this._nonMatchingValues = nonMatchingValues;
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.NOT_IN;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.LONG;
        }

        @Override
        public boolean applySV(long value) {
            return !this._nonMatchingValues.contains(value);
        }
    }

    private static final class IntRawValueBasedNotInPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final IntSet _nonMatchingValues;

        IntRawValueBasedNotInPredicateEvaluator(IntSet nonMatchingValues) {
            this._nonMatchingValues = nonMatchingValues;
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.NOT_IN;
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.INT;
        }

        @Override
        public boolean applySV(int value) {
            return !this._nonMatchingValues.contains(value);
        }
    }

    public static final class DictionaryBasedNotInPredicateEvaluator
    extends BaseDictionaryBasedPredicateEvaluator {
        final IntSet _nonMatchingDictIdSet;
        final int _numNonMatchingDictIds;
        final Dictionary _dictionary;
        int[] _matchingDictIds;
        int[] _nonMatchingDictIds;

        DictionaryBasedNotInPredicateEvaluator(NotInPredicate notInPredicate, Dictionary dictionary, FieldSpec.DataType dataType) {
            List values = notInPredicate.getValues();
            this._nonMatchingDictIdSet = new IntOpenHashSet(HashUtil.getMinHashSetSize((int)values.size()));
            for (String value : values) {
                int dictId = dictionary.indexOf(PredicateUtils.getStoredValue(value, dataType));
                if (dictId < 0) continue;
                this._nonMatchingDictIdSet.add(dictId);
            }
            this._numNonMatchingDictIds = this._nonMatchingDictIdSet.size();
            if (this._numNonMatchingDictIds == 0) {
                this._alwaysTrue = true;
            } else if (dictionary.length() == this._numNonMatchingDictIds) {
                this._alwaysFalse = true;
            }
            this._dictionary = dictionary;
        }

        @Override
        public Predicate.Type getPredicateType() {
            return Predicate.Type.NOT_IN;
        }

        @Override
        public boolean applySV(int dictId) {
            return !this._nonMatchingDictIdSet.contains(dictId);
        }

        @Override
        public int[] getMatchingDictIds() {
            if (this._matchingDictIds == null) {
                int dictionarySize = this._dictionary.length();
                this._matchingDictIds = new int[dictionarySize - this._numNonMatchingDictIds];
                int index = 0;
                for (int dictId = 0; dictId < dictionarySize; ++dictId) {
                    if (this._nonMatchingDictIdSet.contains(dictId)) continue;
                    this._matchingDictIds[index++] = dictId;
                }
            }
            return this._matchingDictIds;
        }

        @Override
        public int getNumNonMatchingDictIds() {
            return this._numNonMatchingDictIds;
        }

        @Override
        public int[] getNonMatchingDictIds() {
            if (this._nonMatchingDictIds == null) {
                this._nonMatchingDictIds = this._nonMatchingDictIdSet.toIntArray();
            }
            return this._nonMatchingDictIds;
        }
    }
}

