/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.query;

import java.util.Collection;
import java.util.Map;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.data.table.IntermediateRecord;
import org.apache.pinot.core.data.table.TableResizer;
import org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.core.operator.ExecutionStatistics;
import org.apache.pinot.core.operator.blocks.IntermediateResultsBlock;
import org.apache.pinot.core.operator.blocks.TransformBlock;
import org.apache.pinot.core.operator.transform.TransformOperator;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.DefaultGroupByExecutor;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.startree.executor.StarTreeGroupByExecutor;
import org.apache.pinot.core.util.GroupByUtils;
import org.apache.pinot.core.util.QueryOptions;
import org.apache.pinot.spi.data.FieldSpec;

public class AggregationGroupByOrderByOperator
extends BaseOperator<IntermediateResultsBlock> {
    private static final String OPERATOR_NAME = "AggregationGroupByOrderByOperator";
    private final AggregationFunction[] _aggregationFunctions;
    private final ExpressionContext[] _groupByExpressions;
    private final int _maxInitialResultHolderCapacity;
    private final int _numGroupsLimit;
    private final int _minSegmentTrimSize;
    private final TransformOperator _transformOperator;
    private final long _numTotalDocs;
    private final boolean _useStarTree;
    private final DataSchema _dataSchema;
    private final QueryContext _queryContext;
    private int _numDocsScanned = 0;

    public AggregationGroupByOrderByOperator(AggregationFunction[] aggregationFunctions, ExpressionContext[] groupByExpressions, int maxInitialResultHolderCapacity, int numGroupsLimit, int minSegmentTrimSize, TransformOperator transformOperator, long numTotalDocs, QueryContext queryContext, boolean useStarTree) {
        int i;
        this._aggregationFunctions = aggregationFunctions;
        this._groupByExpressions = groupByExpressions;
        this._maxInitialResultHolderCapacity = maxInitialResultHolderCapacity;
        this._numGroupsLimit = numGroupsLimit;
        this._transformOperator = transformOperator;
        this._numTotalDocs = numTotalDocs;
        this._useStarTree = useStarTree;
        this._queryContext = queryContext;
        this._minSegmentTrimSize = minSegmentTrimSize;
        int numGroupByExpressions = groupByExpressions.length;
        int numAggregationFunctions = aggregationFunctions.length;
        int numColumns = numGroupByExpressions + numAggregationFunctions;
        String[] columnNames = new String[numColumns];
        DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[numColumns];
        for (i = 0; i < numGroupByExpressions; ++i) {
            ExpressionContext groupByExpression = groupByExpressions[i];
            columnNames[i] = groupByExpression.toString();
            columnDataTypes[i] = DataSchema.ColumnDataType.fromDataTypeSV((FieldSpec.DataType)this._transformOperator.getResultMetadata(groupByExpression).getDataType());
        }
        for (i = 0; i < numAggregationFunctions; ++i) {
            AggregationFunction aggregationFunction = aggregationFunctions[i];
            int index = numGroupByExpressions + i;
            columnNames[index] = aggregationFunction.getResultColumnName();
            columnDataTypes[index] = aggregationFunction.getIntermediateResultColumnType();
        }
        this._dataSchema = new DataSchema(columnNames, columnDataTypes);
    }

    @Override
    protected IntermediateResultsBlock getNextBlock() {
        TransformBlock transformBlock;
        DefaultGroupByExecutor groupByExecutor = this._useStarTree ? new StarTreeGroupByExecutor(this._aggregationFunctions, this._groupByExpressions, this._maxInitialResultHolderCapacity, this._numGroupsLimit, this._transformOperator) : new DefaultGroupByExecutor(this._aggregationFunctions, this._groupByExpressions, this._maxInitialResultHolderCapacity, this._numGroupsLimit, this._transformOperator);
        while ((transformBlock = (TransformBlock)this._transformOperator.nextBlock()) != null) {
            this._numDocsScanned += transformBlock.getNumDocs();
            groupByExecutor.process(transformBlock);
        }
        int minSegmentTrimSize = this.calculateMinSegmentTrimSize();
        if (this._queryContext.getOrderByExpressions() == null || minSegmentTrimSize <= 0) {
            return new IntermediateResultsBlock(this._aggregationFunctions, groupByExecutor.getResult(), this._dataSchema);
        }
        int trimSize = GroupByUtils.getTableCapacity(this._queryContext.getLimit(), minSegmentTrimSize);
        if (groupByExecutor.getNumGroups() <= trimSize) {
            return new IntermediateResultsBlock(this._aggregationFunctions, groupByExecutor.getResult(), this._dataSchema);
        }
        TableResizer tableResizer = new TableResizer(this._dataSchema, this._queryContext);
        Collection<IntermediateRecord> intermediateRecords = groupByExecutor.trimGroupByResult(trimSize, tableResizer);
        return new IntermediateResultsBlock(this._aggregationFunctions, intermediateRecords, this._dataSchema);
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }

    @Override
    public ExecutionStatistics getExecutionStatistics() {
        long numEntriesScannedInFilter = this._transformOperator.getExecutionStatistics().getNumEntriesScannedInFilter();
        long numEntriesScannedPostFilter = (long)this._numDocsScanned * (long)this._transformOperator.getNumColumnsProjected();
        return new ExecutionStatistics(this._numDocsScanned, numEntriesScannedInFilter, numEntriesScannedPostFilter, this._numTotalDocs);
    }

    private int calculateMinSegmentTrimSize() {
        Map<String, String> options = this._queryContext.getQueryOptions();
        if (options == null) {
            return this._minSegmentTrimSize;
        }
        boolean queryOptionEnableTrim = QueryOptions.isEnableSegmentTrim(options);
        int queryOptionTrimSize = QueryOptions.getMinSegmentTrimSize(options);
        if (queryOptionTrimSize > 0) {
            return queryOptionTrimSize;
        }
        if (queryOptionEnableTrim && this._minSegmentTrimSize <= 0) {
            return 5000;
        }
        return this._minSegmentTrimSize;
    }
}

