/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.query;

import org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.core.operator.ExecutionStatistics;
import org.apache.pinot.core.operator.blocks.IntermediateResultsBlock;
import org.apache.pinot.core.operator.blocks.TransformBlock;
import org.apache.pinot.core.operator.transform.TransformOperator;
import org.apache.pinot.core.query.aggregation.DefaultAggregationExecutor;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.startree.executor.StarTreeAggregationExecutor;

public class AggregationOperator
extends BaseOperator<IntermediateResultsBlock> {
    private static final String OPERATOR_NAME = "AggregationOperator";
    private final AggregationFunction[] _aggregationFunctions;
    private final TransformOperator _transformOperator;
    private final long _numTotalDocs;
    private final boolean _useStarTree;
    private int _numDocsScanned = 0;

    public AggregationOperator(AggregationFunction[] aggregationFunctions, TransformOperator transformOperator, long numTotalDocs, boolean useStarTree) {
        this._aggregationFunctions = aggregationFunctions;
        this._transformOperator = transformOperator;
        this._numTotalDocs = numTotalDocs;
        this._useStarTree = useStarTree;
    }

    @Override
    protected IntermediateResultsBlock getNextBlock() {
        TransformBlock transformBlock;
        DefaultAggregationExecutor aggregationExecutor = this._useStarTree ? new StarTreeAggregationExecutor(this._aggregationFunctions) : new DefaultAggregationExecutor(this._aggregationFunctions);
        while ((transformBlock = (TransformBlock)this._transformOperator.nextBlock()) != null) {
            this._numDocsScanned += transformBlock.getNumDocs();
            aggregationExecutor.aggregate(transformBlock);
        }
        return new IntermediateResultsBlock(this._aggregationFunctions, aggregationExecutor.getResult(), false);
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }

    @Override
    public ExecutionStatistics getExecutionStatistics() {
        long numEntriesScannedInFilter = this._transformOperator.getExecutionStatistics().getNumEntriesScannedInFilter();
        long numEntriesScannedPostFilter = (long)this._numDocsScanned * (long)this._transformOperator.getNumColumnsProjected();
        return new ExecutionStatistics(this._numDocsScanned, numEntriesScannedInFilter, numEntriesScannedPostFilter, this._numTotalDocs);
    }
}

