/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.data.table.Record;
import org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.core.operator.ExecutionStatistics;
import org.apache.pinot.core.operator.blocks.IntermediateResultsBlock;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctAggregationFunction;
import org.apache.pinot.core.query.distinct.DistinctTable;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;

public class DictionaryBasedDistinctOperator
extends BaseOperator<IntermediateResultsBlock> {
    private static final String OPERATOR_NAME = "DictionaryBasedDistinctOperator";
    private final DistinctAggregationFunction _distinctAggregationFunction;
    private final Dictionary _dictionary;
    private final int _numTotalDocs;
    private final FieldSpec.DataType _dataType;
    private boolean _hasOrderBy;
    private boolean _isAscending;
    private int _numDocsScanned;

    public DictionaryBasedDistinctOperator(FieldSpec.DataType dataType, DistinctAggregationFunction distinctAggregationFunction, Dictionary dictionary, int numTotalDocs) {
        this._dataType = dataType;
        this._distinctAggregationFunction = distinctAggregationFunction;
        this._dictionary = dictionary;
        this._numTotalDocs = numTotalDocs;
        List<OrderByExpressionContext> orderByExpressionContexts = this._distinctAggregationFunction.getOrderByExpressions();
        if (orderByExpressionContexts != null) {
            OrderByExpressionContext orderByExpressionContext = orderByExpressionContexts.get(0);
            this._isAscending = orderByExpressionContext.isAsc();
            this._hasOrderBy = true;
        }
    }

    @Override
    protected IntermediateResultsBlock getNextBlock() {
        DistinctTable distinctTable = this.buildResult();
        return new IntermediateResultsBlock(new AggregationFunction[]{this._distinctAggregationFunction}, Collections.singletonList(distinctTable), false);
    }

    private DistinctTable buildResult() {
        ArrayList<Record> records;
        assert (this._distinctAggregationFunction.getType() == AggregationFunctionType.DISTINCT);
        List<ExpressionContext> expressions = this._distinctAggregationFunction.getInputExpressions();
        ExpressionContext expression = expressions.get(0);
        DataSchema dataSchema = new DataSchema(new String[]{expression.toString()}, new DataSchema.ColumnDataType[]{DataSchema.ColumnDataType.fromDataTypeSV((FieldSpec.DataType)this._dataType)});
        int dictLength = this._dictionary.length();
        int limit = this._distinctAggregationFunction.getLimit();
        int actualLimit = Math.min(limit, dictLength);
        if (!this._hasOrderBy) {
            records = new ArrayList<Record>(actualLimit);
            this._numDocsScanned = actualLimit;
            for (int i = 0; i < actualLimit; ++i) {
                records.add(new Record(new Object[]{this._dictionary.getInternal(i)}));
            }
        } else if (this._dictionary.isSorted()) {
            records = new ArrayList(actualLimit);
            if (this._isAscending) {
                this._numDocsScanned = actualLimit;
                for (int i = 0; i < actualLimit; ++i) {
                    records.add(new Record(new Object[]{this._dictionary.getInternal(i)}));
                }
            } else {
                this._numDocsScanned = actualLimit;
                for (int i = dictLength - 1; i >= dictLength - actualLimit; --i) {
                    records.add(new Record(new Object[]{this._dictionary.getInternal(i)}));
                }
            }
        } else {
            DistinctTable distinctTable = new DistinctTable(dataSchema, this._distinctAggregationFunction.getOrderByExpressions(), limit);
            this._numDocsScanned = dictLength;
            for (int i = 0; i < dictLength; ++i) {
                distinctTable.addWithOrderBy(new Record(new Object[]{this._dictionary.getInternal(i)}));
            }
            return distinctTable;
        }
        return new DistinctTable(dataSchema, records);
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }

    @Override
    public ExecutionStatistics getExecutionStatistics() {
        return new ExecutionStatistics(this._numDocsScanned, 0L, this._numDocsScanned, this._numTotalDocs);
    }
}

