/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.query;

import java.util.Collections;
import org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.core.operator.ExecutionStatistics;
import org.apache.pinot.core.operator.blocks.IntermediateResultsBlock;
import org.apache.pinot.core.operator.blocks.TransformBlock;
import org.apache.pinot.core.operator.transform.TransformOperator;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctAggregationFunction;
import org.apache.pinot.core.query.distinct.DistinctExecutor;
import org.apache.pinot.core.query.distinct.DistinctExecutorFactory;
import org.apache.pinot.core.query.distinct.DistinctTable;
import org.apache.pinot.segment.spi.IndexSegment;

public class DistinctOperator
extends BaseOperator<IntermediateResultsBlock> {
    private static final String OPERATOR_NAME = "DistinctOperator";
    private final IndexSegment _indexSegment;
    private final DistinctAggregationFunction _distinctAggregationFunction;
    private final TransformOperator _transformOperator;
    private final DistinctExecutor _distinctExecutor;
    private int _numDocsScanned = 0;

    public DistinctOperator(IndexSegment indexSegment, DistinctAggregationFunction distinctAggregationFunction, TransformOperator transformOperator) {
        this._indexSegment = indexSegment;
        this._distinctAggregationFunction = distinctAggregationFunction;
        this._transformOperator = transformOperator;
        this._distinctExecutor = DistinctExecutorFactory.getDistinctExecutor(distinctAggregationFunction, transformOperator);
    }

    @Override
    protected IntermediateResultsBlock getNextBlock() {
        TransformBlock transformBlock;
        while ((transformBlock = (TransformBlock)this._transformOperator.nextBlock()) != null) {
            this._numDocsScanned += transformBlock.getNumDocs();
            if (!this._distinctExecutor.process(transformBlock)) continue;
        }
        DistinctTable distinctTable = this._distinctExecutor.getResult();
        return new IntermediateResultsBlock(new AggregationFunction[]{this._distinctAggregationFunction}, Collections.singletonList(distinctTable), false);
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }

    @Override
    public ExecutionStatistics getExecutionStatistics() {
        long numEntriesScannedInFilter = this._transformOperator.getExecutionStatistics().getNumEntriesScannedInFilter();
        long numEntriesScannedPostFilter = (long)this._numDocsScanned * (long)this._transformOperator.getNumColumnsProjected();
        int numTotalDocs = this._indexSegment.getSegmentMetadata().getTotalDocs();
        return new ExecutionStatistics(this._numDocsScanned, numEntriesScannedInFilter, numEntriesScannedPostFilter, numTotalDocs);
    }
}

