/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.query;

import java.util.ArrayList;
import java.util.List;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.common.RowBasedBlockValueFetcher;
import org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.core.operator.ExecutionStatistics;
import org.apache.pinot.core.operator.blocks.IntermediateResultsBlock;
import org.apache.pinot.core.operator.blocks.TransformBlock;
import org.apache.pinot.core.operator.transform.TransformOperator;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.spi.data.FieldSpec;

public class SelectionOnlyOperator
extends BaseOperator<IntermediateResultsBlock> {
    private static final String OPERATOR_NAME = "SelectionOnlyOperator";
    private final IndexSegment _indexSegment;
    private final TransformOperator _transformOperator;
    private final List<ExpressionContext> _expressions;
    private final BlockValSet[] _blockValSets;
    private final DataSchema _dataSchema;
    private final int _numRowsToKeep;
    private final List<Object[]> _rows;
    private int _numDocsScanned = 0;

    public SelectionOnlyOperator(IndexSegment indexSegment, QueryContext queryContext, List<ExpressionContext> expressions, TransformOperator transformOperator) {
        this._indexSegment = indexSegment;
        this._transformOperator = transformOperator;
        this._expressions = expressions;
        int numExpressions = this._expressions.size();
        this._blockValSets = new BlockValSet[numExpressions];
        String[] columnNames = new String[numExpressions];
        DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[numExpressions];
        for (int i = 0; i < numExpressions; ++i) {
            ExpressionContext expression = this._expressions.get(i);
            TransformResultMetadata expressionMetadata = this._transformOperator.getResultMetadata(expression);
            columnNames[i] = expression.toString();
            columnDataTypes[i] = DataSchema.ColumnDataType.fromDataType((FieldSpec.DataType)expressionMetadata.getDataType(), (boolean)expressionMetadata.isSingleValue());
        }
        this._dataSchema = new DataSchema(columnNames, columnDataTypes);
        this._numRowsToKeep = queryContext.getLimit();
        this._rows = new ArrayList<Object[]>(Math.min(this._numRowsToKeep, 10000));
    }

    @Override
    protected IntermediateResultsBlock getNextBlock() {
        TransformBlock transformBlock;
        while ((transformBlock = (TransformBlock)this._transformOperator.nextBlock()) != null) {
            int numExpressions = this._expressions.size();
            for (int i = 0; i < numExpressions; ++i) {
                this._blockValSets[i] = transformBlock.getBlockValueSet(this._expressions.get(i));
            }
            RowBasedBlockValueFetcher blockValueFetcher = new RowBasedBlockValueFetcher(this._blockValSets);
            int numDocsToAdd = Math.min(this._numRowsToKeep - this._rows.size(), transformBlock.getNumDocs());
            this._numDocsScanned += numDocsToAdd;
            for (int i = 0; i < numDocsToAdd; ++i) {
                this._rows.add(blockValueFetcher.getRow(i));
            }
            if (this._rows.size() != this._numRowsToKeep) continue;
            break;
        }
        return new IntermediateResultsBlock(this._dataSchema, this._rows);
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }

    @Override
    public ExecutionStatistics getExecutionStatistics() {
        long numEntriesScannedInFilter = this._transformOperator.getExecutionStatistics().getNumEntriesScannedInFilter();
        long numEntriesScannedPostFilter = (long)this._numDocsScanned * (long)this._transformOperator.getNumColumnsProjected();
        int numTotalDocs = this._indexSegment.getSegmentMetadata().getTotalDocs();
        return new ExecutionStatistics(this._numDocsScanned, numEntriesScannedInFilter, numEntriesScannedPostFilter, numTotalDocs);
    }
}

