/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.streaming;

import io.grpc.stub.StreamObserver;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.pinot.common.exception.QueryException;
import org.apache.pinot.common.proto.Server;
import org.apache.pinot.common.response.ProcessingException;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.DataTable;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.blocks.IntermediateResultsBlock;
import org.apache.pinot.core.operator.combine.BaseCombineOperator;
import org.apache.pinot.core.operator.streaming.StreamingResponseUtils;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.selection.SelectionOperatorUtils;
import org.apache.pinot.spi.exception.EarlyTerminationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingSelectionOnlyCombineOperator
extends BaseCombineOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamingSelectionOnlyCombineOperator.class);
    private static final String OPERATOR_NAME = "StreamingSelectionOnlyCombineOperator";
    private static final IntermediateResultsBlock LAST_RESULTS_BLOCK = new IntermediateResultsBlock(new DataSchema(new String[0], new DataSchema.ColumnDataType[0]), Collections.emptyList());
    private final StreamObserver<Server.ServerResponse> _streamObserver;
    private final int _limit;
    private final AtomicLong _numRowsCollected = new AtomicLong();

    public StreamingSelectionOnlyCombineOperator(List<Operator> operators, QueryContext queryContext, ExecutorService executorService, long endTimeMs, StreamObserver<Server.ServerResponse> streamObserver) {
        super(operators, queryContext, executorService, endTimeMs);
        this._streamObserver = streamObserver;
        this._limit = queryContext.getLimit();
    }

    @Override
    public String getOperatorName() {
        return OPERATOR_NAME;
    }

    @Override
    protected void processSegments(int threadIndex) {
        for (int operatorIndex = threadIndex; operatorIndex < this._numOperators; operatorIndex += this._numTasks) {
            Operator operator = (Operator)this._operators.get(operatorIndex);
            try {
                IntermediateResultsBlock resultsBlock;
                while ((resultsBlock = (IntermediateResultsBlock)operator.nextBlock()) != null) {
                    Collection<Object[]> rows = resultsBlock.getSelectionResult();
                    assert (rows != null);
                    long numRowsCollected = this._numRowsCollected.addAndGet(rows.size());
                    this._blockingQueue.offer(resultsBlock);
                    if (numRowsCollected < (long)this._limit) continue;
                    return;
                }
                this._blockingQueue.offer(LAST_RESULTS_BLOCK);
                continue;
            }
            catch (EarlyTerminationException e) {
                return;
            }
            catch (Exception e) {
                LOGGER.error("Caught exception while executing operator of index: {} (query: {})", new Object[]{operatorIndex, this._queryContext, e});
                this._blockingQueue.offer(new IntermediateResultsBlock(e));
                return;
            }
        }
    }

    @Override
    protected IntermediateResultsBlock mergeResults() throws Exception {
        long numRowsCollected = 0L;
        int numOperatorsFinished = 0;
        while (numRowsCollected < (long)this._limit && numOperatorsFinished < this._numOperators) {
            IntermediateResultsBlock resultsBlock = (IntermediateResultsBlock)this._blockingQueue.poll(this._endTimeMs - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
            if (resultsBlock == null) {
                LOGGER.error("Timed out while polling results block (query: {})", (Object)this._queryContext);
                return new IntermediateResultsBlock((Exception)QueryException.getException((ProcessingException)QueryException.EXECUTION_TIMEOUT_ERROR, (Exception)new TimeoutException("Timed out while polling results block")));
            }
            if (resultsBlock.getProcessingExceptions() != null) {
                return resultsBlock;
            }
            if (resultsBlock == LAST_RESULTS_BLOCK) {
                ++numOperatorsFinished;
                continue;
            }
            DataSchema dataSchema = resultsBlock.getDataSchema();
            Collection<Object[]> rows = resultsBlock.getSelectionResult();
            assert (dataSchema != null && rows != null);
            numRowsCollected += (long)rows.size();
            DataTable dataTable = SelectionOperatorUtils.getDataTableFromRows(rows, dataSchema);
            this._streamObserver.onNext((Object)StreamingResponseUtils.getDataResponse(dataTable));
        }
        return new IntermediateResultsBlock();
    }

    @Override
    protected void mergeResultsBlocks(IntermediateResultsBlock mergedBlock, IntermediateResultsBlock blockToMerge) {
    }
}

