/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.core.plan.DocIdSetPlanNode;
import org.apache.pinot.segment.spi.datasource.DataSource;

public class AdditionTransformFunction
extends BaseTransformFunction {
    public static final String FUNCTION_NAME = "add";
    private double _literalSum = 0.0;
    private List<TransformFunction> _transformFunctions = new ArrayList<TransformFunction>();
    private double[] _sums;

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, DataSource> dataSourceMap) {
        if (arguments.size() < 2) {
            throw new IllegalArgumentException("At least 2 arguments are required for ADD transform function");
        }
        for (TransformFunction argument : arguments) {
            if (argument instanceof LiteralTransformFunction) {
                this._literalSum += Double.parseDouble(((LiteralTransformFunction)argument).getLiteral());
                continue;
            }
            if (!argument.getResultMetadata().isSingleValue()) {
                throw new IllegalArgumentException("All the arguments of ADD transform function must be single-valued");
            }
            this._transformFunctions.add(argument);
        }
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return DOUBLE_SV_NO_DICTIONARY_METADATA;
    }

    @Override
    public double[] transformToDoubleValuesSV(ProjectionBlock projectionBlock) {
        if (this._sums == null) {
            this._sums = new double[DocIdSetPlanNode.MAX_DOC_PER_CALL];
        }
        int length = projectionBlock.getNumDocs();
        Arrays.fill(this._sums, 0, length, this._literalSum);
        for (TransformFunction transformFunction : this._transformFunctions) {
            double[] values = transformFunction.transformToDoubleValuesSV(projectionBlock);
            for (int i = 0; i < length; ++i) {
                int n = i;
                this._sums[n] = this._sums[n] + values[i];
            }
        }
        return this._sums;
    }
}

